% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{simulate.ppgam}
\alias{simulate.ppgam}
\title{Simulations from a fitted \code{ppgam} object}
\usage{
\method{simulate}{ppgam}(object, nsim = 1, seed = NULL, newdata, type = "link", ...)
}
\arguments{
\item{object}{a fitted \code{ppgam} object}

\item{nsim}{an integer giving the number of simulations}

\item{seed}{an integer giving the seed for simulations}

\item{newdata}{a data frame}

\item{type}{a character string, as in \code{predict.ppgam}}

\item{...}{arguments to be passed to \code{predict.ppgam}}
}
\value{
Simulations of parameters
}
\description{
Simulations from a fitted \code{ppgam} object
}
\examples{

# Times of landfalling US hurricanes
data(USlandfall)

# convert dates to years, as a continuous variable
year <- as.integer(format(USlandfall$date, "\%Y"))
day <- as.integer(format(USlandfall$date, "\%j"))
USlandfall$year <- year + pmin(day / 365, 1)
hits <- subset(USlandfall, landfall == 1)

# this creates nodes in the default way
m1 <- ppgam( ~ s(year), hits)
simulate(m1)
simulate(m1, type = "response")
simulate(m1, newdata = data.frame(year = c(2000, 2001)))

}
\seealso{
\link{predict.ppgam}
}
