% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdb.R, R/pdb_github.R
\name{pdb_local}
\alias{pdb_local}
\alias{pdb}
\alias{pdb.default}
\alias{pdb.pdb_model_code}
\alias{pdb.character}
\alias{pdb_default}
\alias{pdb_config}
\alias{pdb_github}
\title{Create a Posterior Database (pdb) connection}
\usage{
pdb_local(
  path = getOption("pdb_path", Sys.getenv("PDB_PATH")),
  cache_path = tempdir()
)

pdb(x, ...)

\method{pdb}{default}(x, ...)

\method{pdb}{pdb_model_code}(x, ...)

\method{pdb}{character}(x, pdb_type = "local", cache_path = tempdir(), ...)

pdb_default(cache_path = tempdir())

pdb_config(directory = getwd())

pdb_github(
  repo = getOption("pdb_repo", "stan-dev/posteriordb"),
  cache_path = tempdir(),
  ref = "master",
  subdir = NULL,
  auth_token = github_pat(),
  host = "https://api.github.com"
)
}
\arguments{
\item{path}{a local path to a posterior database. Defaults to `pdb_path` option or PDB_PATH environment variable.}

\item{cache_path}{The path to the pdb cache. Default is R temporary directory.
This is used to store files locally and without affecting the database.}

\item{x}{an object to access a pdb for, if character this is how to identify the pdb (path for local pdb, repo for github pdb)}

\item{...}{further arguments for specific methods to setup a pdb.}

\item{pdb_type}{Type of posterior database connection. Either \code{local} or \code{github}.}

\item{directory}{the directory to look for the [.pdb_config.yml] file}

\item{repo}{Repository address in the format
`username/repo[/subdir][@ref|#pull]`. Alternatively, you can
specify `subdir` and/or `ref` using the respective parameters
(see below); if both is specified, the values in `repo` take
precedence.}

\item{ref}{Desired git reference. Could be a commit, tag, or branch
name. Defaults to `"master"`.}

\item{subdir}{subdirectory within repo that contains the posterior database.}

\item{auth_token}{To use a private repo, generate a personal
access token (PAT) in "https://github.com/settings/tokens" and
supply to this argument. This is safer than using a password because
you can easily delete a PAT without affecting any others. Defaults to
the `GITHUB_PAT` environment variable.}

\item{host}{GitHub API host to use. Override with your GitHub enterprise
hostname, for example, `"github.hostname.com/api/v3"`.}
}
\value{
a \code{pdb} object
}
\description{
Create a Posterior Database (pdb) connection
}
\details{
Connect to a posterior database locally or in a github repo.

[pdb_config()] read  [.pdb_config.yml] in [directory] and use that to setup a
pdb connection.

The connection [pdb_default()] first checks if there exists a [.pdb_config.yml]
file in the working directory. If it exist, [pdb_config()] is used to setup,
the connection. If no [.pdb_config.yml] file is found, [pdb_local()] is used to
setup a pdb. If no local pdb is found, [pdb_github()] is used.
}
