% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pdb.R
\name{check_pdb}
\alias{check_pdb}
\alias{check_pdb_read_model_code}
\alias{check_pdb_aliases}
\alias{check_pdb_read_data}
\alias{check_pdb_read_reference_posterior_draws}
\alias{check_pdb_posterior_run_stan}
\alias{check_pdb_references}
\alias{check_pdb_posterior_references}
\alias{check_pdb_all_models_have_posterior}
\alias{check_pdb_all_data_have_posterior}
\alias{check_pdb_all_reference_posteriors_have_posterior}
\title{Check the content a posterior database}
\usage{
check_pdb(
  pdb,
  posterior_names_to_check = NULL,
  run_stan_code_checks = FALSE,
  verbose = TRUE
)

check_pdb_read_model_code(posterior_list)

check_pdb_aliases(pdb)

check_pdb_read_data(posterior_list)

check_pdb_read_reference_posterior_draws(posterior_list)

check_pdb_posterior_run_stan(po)

check_pdb_references(pdb)

check_pdb_posterior_references(posterior_list)

check_pdb_all_models_have_posterior(pdb)

check_pdb_all_data_have_posterior(pdb)

check_pdb_all_reference_posteriors_have_posterior(pdb)
}
\arguments{
\item{pdb}{a \code{pdb} object}

\item{posterior_names_to_check}{an vector indicating what posteriors to check in the pdb. Default is NULL (all).}

\item{run_stan_code_checks}{should checks using Stan be run?}

\item{verbose}{should check results be printed?}

\item{posterior_list}{a list of \code{pdb_posterior} objects.}

\item{po}{a \code{pdb_posterior} object.}
}
\value{
a boolean indicating if the pdb works as it should.
}
\description{
Check the content a posterior database
}
\details{
[check_pdb()] checks that the content exists as specified
[check_pdb_run_stan()] test to run all posteriors with stan models.
[check_pdb_stan_syntax()] check that all stan model code files can be parsed.
[check_pdb_aliases()] check that all alias are correct.
[check_pdb_read_model_code()] check that posteriors can be read.
[check_pdb_posteriors()] check a vector of posterior names.
[check_pdb_references()] check that all references in posteriors also exist in bibtex.
[check_pdb_all_models_have_posterior()] check that all models belong to a posterior
[check_pdb_all_data_have_posterior()] check that all datasets belong to a posterior
[check_pdb_all_reference_posteriors_have_posterior()] check that all reference posteriors belong to a posterior
}
