## Pull Request Template

Please, go through these steps before you submit a PR.

1. Please make sure that:

    a. You have made your changes in a separate branch. Branches MUST have descriptive names that start with either the `fix/`, `feat/` or `refactor/` prefixes (similar to the [git guidelines](./contributing.md#-git-commit-standards) for this project). Good examples are: `fix/mutate` or `feat/arrange`.

    b. You have a descriptive commit message with a short title (first line).

    c. Your commit message follows the [git commit standards](./contributing.md#-git-commit-standards) of the repository.

    d. You have only one commit (if not, squash them into one commit).

    e. `tinytest::test_all()` does not throw any errors.

    f. You have added any new necessary tests to test your fix or new feature.

2. **After** these steps, you're ready to open a pull request.

    a. Give a descriptive title to your PR.

    b. Provide a description of your changes.

    c. Put `Closes #XXXX` (or `Fixes #XXXX`) in your comment to auto-close the issue that your PR introduces a new feature (or fixes), if any.

IMPORTANT: Please review the [contributing.md](./contributing.md) file for detailed contributing guidelines.

**PLEASE REMOVE THIS TEMPLATE BEFORE SUBMITTING**
