% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection.R
\name{prune}
\alias{prune}
\alias{prune.file_collection}
\title{Remove files from a file collection}
\usage{
prune(x, path)

\method{prune}{file_collection}(x, path)
}
\arguments{
\item{x}{File collection.}

\item{path}{Character vector. Relative paths of the files to remove.}
}
\value{
Pruned file collection.
}
\description{
Remove files from a file collection
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Remove the rows from the data frame whose relative paths
    match the given paths exactly.
    \item Create a new file collection object with the pruned data frame.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
system.file("examples/pkg1/", package = "pkglite") \%>\%
  collate(file_default()) \%>\%
  prune(path = c("NEWS.md", "man/figures/logo.png"))
}
