% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_new_pillar.R
\name{ctl_new_pillar}
\alias{ctl_new_pillar}
\alias{ctl_new_rowid_pillar}
\title{Customize the appearance of simple pillars in your tibble subclass}
\usage{
ctl_new_pillar(controller, x, width, ..., title = NULL)

ctl_new_rowid_pillar(controller, x, width, ..., title = NULL, type = NULL)
}
\arguments{
\item{controller}{The object of class \code{"tbl"} currently printed.}

\item{x}{A simple (one-dimensional) vector.}

\item{width}{The available width, can be a vector for multiple tiers.}

\item{...}{These dots are for future extensions and must be empty.}

\item{title}{The title, derived from the name of the column in the data.}

\item{type}{String for specifying a row ID type. Current values in use are
\code{NULL} and \code{"*"}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Gain full control over the appearance of the pillars of your tibble subclass
in its body.
This method is intended for implementers of subclasses of the \code{"tbl"} class.
Users will rarely need them.
}
\details{
\code{ctl_new_pillar()} is called to construct pillars for regular (one-dimensional)
vectors.
The default implementation returns an object constructed with \code{\link[=pillar]{pillar()}}.
Extend this method to modify the pillar components returned from the default
implementation.
Override this method to completely change the appearance of the pillars.
Components are created with \code{\link[=new_pillar_component]{new_pillar_component()}} or \code{\link[=pillar_component]{pillar_component()}}.
In order to customize printing of row IDs, a method can be supplied for the
\code{ctl_new_rowid_pillar()} generic.

All components must be of the same height.
This restriction may be levied in the future.

Implementations should return \code{NULL} if none of the data
fits the available width.
}
\examples{
\dontshow{if (rlang::is_installed("palmerpenguins") && requireNamespace("tibble")) withAutoprint(\{ # examplesIf}
# Create pillar objects
ctl_new_pillar(
  palmerpenguins::penguins,
  palmerpenguins::penguins$species[1:3],
  width = 60
)

ctl_new_pillar(
  palmerpenguins::penguins,
  palmerpenguins::penguins$bill_length_mm[1:3],
  width = 60
)
\dontshow{\}) # examplesIf}

# Customize output
lines <- function(char = "-") {
  stopifnot(nchar(char) == 1)
  structure(char, class = "lines")
}

format.lines <- function(x, width, ...) {
  paste(rep(x, width), collapse = "")
}

ctl_new_pillar.line_tbl <- function(controller, x, width, ...) {
  out <- NextMethod()
  new_pillar(list(
    title = out$title,
    type = out$type,
    lines = new_pillar_component(list(lines("=")), width = 1),
    data = out$data
  ))
}

ctl_new_rowid_pillar.line_tbl <- function(controller, x, width, ...) {
  out <- NextMethod()
  new_pillar(
    list(
      title = out$title,
      type = out$type,
      lines = new_pillar_component(list(lines("=")), width = 1),
      data = out$data
    ),
    width = as.integer(floor(log10(max(nrow(x), 1))) + 1)
  )
}

vctrs::new_data_frame(
  list(a = 1:3, b = letters[1:3]),
  class = c("line_tbl", "tbl")
)

ctl_new_rowid_pillar.roman_tbl <- function(controller, x, width, ...) {
  out <- NextMethod()
  rowid <- utils::as.roman(seq_len(nrow(x)))
  width <- max(nchar(as.character(rowid)))
  new_pillar(
    list(
      title = out$title,
      type = out$type,
      data = pillar_component(
        new_pillar_shaft(list(row_ids = rowid),
          width = width,
          class = "pillar_rif_shaft"
        )
      )
    ),
    width = width
  )
}

vctrs::new_data_frame(
  list(a = 1:3, b = letters[1:3]),
  class = c("roman_tbl", "tbl")
)

}
\seealso{
See \code{\link[=ctl_new_pillar_list]{ctl_new_pillar_list()}} for creating pillar objects for compound columns:
packed data frames, matrices, or arrays.
}
