% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{buildModelFuncs}
\alias{buildModelFuncs}
\title{Build c++ particle filtering code for your R session.}
\usage{
buildModelFuncs(myDir, modelName, verbose = FALSE)
}
\arguments{
\item{myDir}{directory with your three code files (i.e. model header, model source and export code)}

\item{modelName}{your model name. Must be in all lowercase, and be a substring of the above-mentioned filenames}

\item{verbose}{logical and passed in to inline::cxxfunction()}
}
\value{
an Rcpp Module object
}
\description{
Build c++ particle filtering code for your R session.
}
\examples{
\dontrun{
# compile everything from scratch
svol_lev <- buildModelFuncs("~/Desktop", "svol_leverage")

# then use your model's log-likelihood and filtering functions
svol_lev$svol_leverage_bswc_approx_LL(rnorm(100), c(.9, 0.0, 1.0, -.2))
svol_lev$svol_leverage_bswc_approx_filt(rnorm(100), c(.9, 0.0, 1.0, -.2))
}
}
