% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pexp.R
\name{PExp}
\alias{PExp}
\alias{dpexp}
\alias{ppexp}
\alias{qpexp}
\alias{rpexp}
\title{Probability function, distribution function, quantile function and random generation for the Piecewise Exponential (PE) distribution.}
\usage{
dpexp(x, tgrid, rates, log = FALSE)

ppexp(q, tgrid, rates, lower.tail = TRUE, log.p = FALSE)

qpexp(p, tgrid, rates, lower.tail = TRUE, log.p = FALSE)

rpexp(n, tgrid, rates)
}
\arguments{
\item{x}{vector of time points.}

\item{tgrid}{vector of time grid knots.}

\item{rates}{vector of failure rates.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\value{
dpexp gives the (log) probability function, ppexp gives the (log) distribution function, qpexp gives the quantile function, and rpexp generates random deviates.
}
\description{
Probability function, distribution function, quantile function and random generation for the Piecewise Exponential (PE) distribution.
}
\examples{
n <- 10
tgrid <- c(0, 1, 3, 7, Inf)
rates <- c(0.5, 4, 0.8, 0.1)
x <- sort(rpexp(n, tgrid=tgrid, rates=rates))
Fx <- ppexp(x, tgrid, rates)
y <- qpexp(Fx, tgrid, rates)
# checking:
x==y
}
