% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{compare_column_space}
\alias{compare_column_space}
\title{Compare column spaces}
\usage{
compare_column_space(X1, X2)
}
\arguments{
\item{X1, X2}{matrices with the same number of rows}
}
\value{
\itemize{
\item -1 : Either C(X1)=C(X2), or the spaces are not nested.
\item 0 : C(X1) is contained in C(X2)
\item 1 : C(X2) is contained in C(X1)
}
}
\description{
Compare column spaces of two matrices
}
\examples{

A1 <- matrix(c(1,1,1,1,2,3), nrow=3)
A2 <- A1[, 1, drop=FALSE]

compare_column_space(A1, A2)
compare_column_space(A2, A1)
compare_column_space(A1, A1)

}
