% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamSet.R
\name{ParamSet}
\alias{ParamSet}
\title{ParamSet}
\description{
An object representing the space of possible parametrizations of a function or another object.
\code{ParamSet}s are used on the side of objects being parameterized, where they function as a configuration space determining the set of possible configurations accepted by these objects.
They can also be used to specify search spaces for optimization, indicating the set of legal configurations to try out.
It is often convenient to generate search spaces from configuration spaces, which can be done using the \verb{$search_space()} method in combination with \code{to_tune()} / \code{\link{TuneToken}} objects.

Individual dimensions of a \code{ParamSet} are specified by \code{\link{Domain}} objects, created as \code{\link[=p_dbl]{p_dbl()}}, \code{\link[=p_lgl]{p_lgl()}} etc.
The field \verb{$values} can be used to store an active configuration or to partially fix
some parameters to constant values -- the precise effect can be determined by the object being parameterized.

Constructing a \code{ParamSet} can be done using \code{ParamSet$new()} in combination with a named list of \code{\link{Domain}} objects.
This route is recommended when the set of dimensions (i.e. the members of this named list) is dynamically created, such as when the number of parameters is variable.
\code{ParamSet}s can also be created using the \code{\link[=ps]{ps()}} shorthand, which is the recommended way when the set of parameters is fixed.
In practice, the majority of cases where a \code{ParamSet} is created, the \code{\link[=ps]{ps()}} should be used.
}
\section{S3 methods and type converters}{

\itemize{
\item \code{as.data.table()}\cr
\code{ParamSet} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Compact representation as datatable. Col types are:\cr
\itemize{
\item id: character
\item class: character
\item lower, upper: numeric
\item levels: list col, with NULL elements
\item nlevels: integer valued numeric
\item is_bounded: logical
\item special_vals: list col of list
\item default: list col
\item storage_type: character
\item tags: list col of character vectors
}
}
}

\examples{
pset = ParamSet$new(
  params = list(
    d = p_dbl(lower = -5, upper = 5, default = 0, trafo = function(x) 2^x),
    f = p_fct(levels = letters[1:3])
  )
)

# alternative, recommended way of construction in this case since the
# parameter list is not dynamic:
pset = ps(
  d = p_dbl(lower = -5, upper = 5, default = 0, trafo = function(x) 2^x),
  f = p_fct(levels = letters[1:3])
)

pset$check(list(d = 2.1, f = "a"))

pset$check(list(d = 2.1, f = "d"))
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{assert_values}}{(\code{logical(1)})\cr
Should values be checked for validity during assigment to active binding \verb{$values}?
Default is \code{TRUE}, only switch this off if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{data}}{(\code{data.table}) \code{data.table} representation of the \code{ParamSet}.}

\item{\code{values}}{(named \code{list()})\cr
Currently set / fixed parameter values.
Settable, and feasibility of values will be checked when you set them.
You do not have to set values for all parameters, but only for a subset.
When you set values, all previously set values will be unset / removed.}

\item{\code{tags}}{(named \code{list()} of \code{character()})\cr
Can be used to group and subset parameters.
Named with parameter IDs.}

\item{\code{params}}{(named \code{list()})\cr
\code{data.table} representing the combined \code{\link{Domain}} objects used to construct the \code{\link{ParamSet}}.
Used for internal purpuses.
Its use by external code is deprecated.}

\item{\code{domains}}{(named \code{list} of \code{\link{Domain}})
List of \code{\link{Domain}} objects that could be used to initialize this \code{ParamSet}.}

\item{\code{extra_trafo}}{(\verb{function(x, param_set)})\cr
Transformation function. Settable.
User has to pass a \verb{function(x)}, of the form\cr
(named \code{list()}, \link{ParamSet}) -> named \code{list()}.\cr
The function is responsible to transform a feasible configuration into another encoding,
before potentially evaluating the configuration with the target algorithm.
For the output, not many things have to hold.
It needs to have unique names, and the target algorithm has to accept the configuration.
For convenience, the self-paramset is also passed in, if you need some info from it (e.g. tags).
Is NULL by default, and you can set it to NULL to switch the transformation off.}

\item{\code{constraint}}{(\verb{function(x)})\cr
Constraint function. Settable.
This function must evaluate a named \code{list()} of values and determine whether it satisfies
constraints, returning a scalar \code{logical(1)} value.}

\item{\code{deps}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Table has cols \code{id} (\code{character(1)}) and \code{on} (\code{character(1)}) and \code{cond} (\link{Condition}).
Lists all (direct) dependency parents of a param, through parameter IDs.
Internally created by a call to \code{add_dep}.
Settable, if you want to remove dependencies or perform other changes.}

\item{\code{length}}{(\code{integer(1)})\cr Number of contained parameters.}

\item{\code{is_empty}}{(\code{logical(1)})\cr Is the \code{ParamSet} empty? Named with parameter IDs.}

\item{\code{has_trafo}}{(\code{logical(1)})\cr Whether a \code{trafo} function is present, in parameters or in \code{extra_trafo}.}

\item{\code{has_extra_trafo}}{(\code{logical(1)})\cr Whether \code{extra_trafo} is set.}

\item{\code{has_deps}}{(\code{logical(1)})\cr Whether the parameter dependencies are present}

\item{\code{has_constraint}}{(\code{logical(1)})\cr Whether parameter constraint is set.}

\item{\code{all_numeric}}{(\code{logical(1)})\cr Is \code{TRUE} if all parameters are \code{\link[=p_dbl]{p_dbl()}} or \code{\link[=p_int]{p_int()}}.}

\item{\code{all_categorical}}{(\code{logical(1)})\cr Is \code{TRUE} if all parameters are \code{\link[=p_fct]{p_fct()}} and \code{\link[=p_lgl]{p_lgl()}}.}

\item{\code{all_bounded}}{(\code{logical(1)})\cr Is \code{TRUE} if all parameters are bounded.}

\item{\code{class}}{(named \code{character()})\cr Classes of contained parameters. Named with parameter IDs.}

\item{\code{lower}}{(named \code{double()})\cr Lower bounds of numeric parameters (\code{NA} for non-numerics). Named with parameter IDs.}

\item{\code{upper}}{(named \code{double()})\cr Upper bounds of numeric parameters (\code{NA} for non-numerics). Named with parameter IDs.}

\item{\code{levels}}{(named \code{list()} of \code{character})\cr Allowed levels of categorical parameters (\code{NULL} for non-categoricals).
Named with parameter IDs.}

\item{\code{storage_type}}{(\code{character()})\cr Data types of parameters when stored in tables. Named with parameter IDs.}

\item{\code{special_vals}}{(named \code{list()} of \code{list()})\cr Special values for all parameters. Named with parameter IDs.}

\item{\code{default}}{(named \code{list()})\cr Default values of all parameters. If no default exists, element is not present.
Named with parameter IDs.}

\item{\code{has_trafo_param}}{(\code{logical()})\cr Whether \code{trafo} is set for any parameter.}

\item{\code{is_logscale}}{(\code{logical()})\cr Whether \code{trafo} was set to \code{logscale} during construction.\cr
Note that this only refers to the \code{logscale} flag set during construction, e.g. \code{p_dbl(logscale = TRUE)}.
If the parameter was set to logscale manually, e.g. through \code{p_dbl(trafo = exp)},
this \code{is_logscale} will be \code{FALSE}.}

\item{\code{nlevels}}{(named \code{integer()})\cr Number of distinct levels of parameters. \code{Inf} for double parameters or unbounded integer parameters.
Named with param IDs.}

\item{\code{is_number}}{(named \code{logical()})\cr Whether parameter is \code{\link[=p_dbl]{p_dbl()}} or \code{\link[=p_int]{p_int()}}. Named with parameter IDs.}

\item{\code{is_categ}}{(named \code{logical()})\cr Whether parameter is \code{\link[=p_fct]{p_fct()}} or \code{\link[=p_lgl]{p_lgl()}}. Named with parameter IDs.}

\item{\code{is_bounded}}{(named \code{logical()})\cr Whether parameters have finite bounds. Named with parameter IDs.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParamSet-new}{\code{ParamSet$new()}}
\item \href{#method-ParamSet-ids}{\code{ParamSet$ids()}}
\item \href{#method-ParamSet-get_values}{\code{ParamSet$get_values()}}
\item \href{#method-ParamSet-set_values}{\code{ParamSet$set_values()}}
\item \href{#method-ParamSet-trafo}{\code{ParamSet$trafo()}}
\item \href{#method-ParamSet-aggr_internal_tuned_values}{\code{ParamSet$aggr_internal_tuned_values()}}
\item \href{#method-ParamSet-disable_internal_tuning}{\code{ParamSet$disable_internal_tuning()}}
\item \href{#method-ParamSet-convert_internal_search_space}{\code{ParamSet$convert_internal_search_space()}}
\item \href{#method-ParamSet-test_constraint}{\code{ParamSet$test_constraint()}}
\item \href{#method-ParamSet-test_constraint_dt}{\code{ParamSet$test_constraint_dt()}}
\item \href{#method-ParamSet-check}{\code{ParamSet$check()}}
\item \href{#method-ParamSet-check_dependencies}{\code{ParamSet$check_dependencies()}}
\item \href{#method-ParamSet-test}{\code{ParamSet$test()}}
\item \href{#method-ParamSet-assert}{\code{ParamSet$assert()}}
\item \href{#method-ParamSet-check_dt}{\code{ParamSet$check_dt()}}
\item \href{#method-ParamSet-test_dt}{\code{ParamSet$test_dt()}}
\item \href{#method-ParamSet-assert_dt}{\code{ParamSet$assert_dt()}}
\item \href{#method-ParamSet-qunif}{\code{ParamSet$qunif()}}
\item \href{#method-ParamSet-get_domain}{\code{ParamSet$get_domain()}}
\item \href{#method-ParamSet-subset}{\code{ParamSet$subset()}}
\item \href{#method-ParamSet-subspaces}{\code{ParamSet$subspaces()}}
\item \href{#method-ParamSet-flatten}{\code{ParamSet$flatten()}}
\item \href{#method-ParamSet-search_space}{\code{ParamSet$search_space()}}
\item \href{#method-ParamSet-add_dep}{\code{ParamSet$add_dep()}}
\item \href{#method-ParamSet-format}{\code{ParamSet$format()}}
\item \href{#method-ParamSet-print}{\code{ParamSet$print()}}
\item \href{#method-ParamSet-clone}{\code{ParamSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$new(params = named_list(), allow_dangling_dependencies = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{(named \code{list()})\cr
List of \code{\link{Domain}}, named with their respective ID.}

\item{\code{allow_dangling_dependencies}}{(\code{character(1)})\cr
Whether dependencies depending on parameters that are not present should be allowed. A parameter \code{x} having
\code{depends = y == 0} if \code{y} is not present would usually throw an error, but if dangling
dependencies are allowed, the dependency is added regardless. This is mainly for internal
use.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-ids"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-ids}{}}}
\subsection{Method \code{ids()}}{
Retrieves IDs of contained parameters based on some filter criteria
selections, \code{NULL} means no restriction.
Only returns IDs of parameters that satisfy all conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$ids(class = NULL, tags = NULL, any_tags = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class}}{(\code{character()})\cr
Typically a subset of \code{"ParamDbl"}, \code{"ParamInt"}, \code{"ParamFct"}, \code{"ParamLgl"}, \code{"ParamUty"}.
Other classes are possible if implemented by 3rd party packages.
Return only IDs of dimensions with the given class.}

\item{\code{tags}}{(\code{character()}).
Return only IDs of dimensions that have \emph{all} tags given in this argument.}

\item{\code{any_tags}}{(\code{character()}).
Return only IDs of dimensions that have at least one of the tags given in this argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{character()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-get_values}{}}}
\subsection{Method \code{get_values()}}{
Retrieves parameter values based on some selections, \code{NULL} means no
restriction and is equivalent to \verb{$values}.
Only returns values of parameters that satisfy all conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$get_values(
  class = NULL,
  tags = NULL,
  any_tags = NULL,
  type = "with_token",
  check_required = TRUE,
  remove_dependencies = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class}}{(\code{character()}). See \verb{$ids()}.}

\item{\code{tags}}{(\code{character()}). See \verb{$ids()}.}

\item{\code{any_tags}}{(\code{character()}). See \verb{$ids()}.}

\item{\code{type}}{(\code{character(1)})\cr
Return values \code{"with_token"} (i.e. all values),}

\item{\code{check_required}}{(\code{logical(1)})\cr
Check if all required parameters are set?}

\item{\code{remove_dependencies}}{(\code{logical(1)})\cr
If \code{TRUE}, set values with dependencies that are not fulfilled to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{list()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-set_values"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-set_values}{}}}
\subsection{Method \code{set_values()}}{
Allows to to modify (and overwrite) or replace the parameter values.
Per default already set values are being kept unless new values are being provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$set_values(..., .values = list(), .insert = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Named parameter values.}

\item{\code{.values}}{(named \code{list()})\cr
Named list with parameter values. Names must not already appear in \code{...}.}

\item{\code{.insert}}{(\code{logical(1)})\cr
Whether to insert the values (old values are being kept, if not overwritten), or to
replace all values. Default is TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-trafo"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-trafo}{}}}
\subsection{Method \code{trafo()}}{
Perform transformation specified by the \code{trafo} of \code{\link{Domain}} objects, as well as the \verb{$extra_trafo} field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$trafo(x, param_set = self)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(named \code{list()} | \code{data.frame})\cr
The value(s) to be transformed.}

\item{\code{param_set}}{(\code{ParamSet})\cr
Passed to \code{extra_trafo()}. Note that the \code{extra_trafo} of \code{self} is used, not the \code{extra_trafo} of the
\code{ParamSet} given in the \code{param_set} argument.
In almost all cases, the default \code{param_set = self} should be used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-aggr_internal_tuned_values"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-aggr_internal_tuned_values}{}}}
\subsection{Method \code{aggr_internal_tuned_values()}}{
Aggregate parameter values according to their aggregation rules.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$aggr_internal_tuned_values(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(named \code{list()} of \code{list()}s)\cr
The value(s) to be aggregated. Names are parameter values.
The aggregation function is selected based on the parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(named \code{list()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-disable_internal_tuning"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-disable_internal_tuning}{}}}
\subsection{Method \code{disable_internal_tuning()}}{
Set the parameter values so that internal tuning for the selected parameters is disabled.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$disable_internal_tuning(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character()})\cr
The ids of the parameters for which to disable internal tuning.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{Self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-convert_internal_search_space"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-convert_internal_search_space}{}}}
\subsection{Method \code{convert_internal_search_space()}}{
Convert all parameters from the search space to parameter values using the transformation given by
\code{in_tune_fn}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$convert_internal_search_space(search_space)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_space}}{(\code{\link{ParamSet}})\cr
The internal search space.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(named \code{list()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-test_constraint"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-test_constraint}{}}}
\subsection{Method \code{test_constraint()}}{
\pkg{checkmate}-like test-function. Takes a named list.
Return \code{FALSE} if the given \verb{$constraint} is not satisfied, \code{TRUE} otherwise.
Note this is different from satisfying the bounds or types given by the \code{ParamSet} itself:
If \code{x} does not satisfy these, an error will be thrown, given that \code{assert_value} is \code{TRUE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$test_constraint(x, assert_value = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(named \code{list()})\cr
The value to test.}

\item{\code{assert_value}}{(\code{logical(1)})\cr
Whether to verify that \code{x} satisfies the bounds and types given by this \code{ParamSet}.
Should be \code{TRUE} unless this was already checked before.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}: Whether \code{x} satisfies the \verb{$constraint}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-test_constraint_dt"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-test_constraint_dt}{}}}
\subsection{Method \code{test_constraint_dt()}}{
\pkg{checkmate}-like test-function. Takes a \code{\link[data.table:data.table]{data.table}}.
For each row, return \code{FALSE} if the given \verb{$constraint} is not satisfied, \code{TRUE} otherwise.
Note this is different from satisfying the bounds or types given by the \code{ParamSet} itself:
If \code{x} does not satisfy these, an error will be thrown, given that \code{assert_value} is \code{TRUE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$test_constraint_dt(x, assert_value = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{data.table})\cr
The values to test.}

\item{\code{assert_value}}{(\code{logical(1)})\cr
Whether to verify that \code{x} satisfies the bounds and types given by this \code{ParamSet}.
Should be \code{TRUE} unless this was already checked before.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical}: For each row in \code{x}, whether it satisfies the \verb{$constraint}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-check"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-check}{}}}
\subsection{Method \code{check()}}{
\pkg{checkmate}-like check-function. Takes a named list.
A point x is feasible, if it configures a subset of params,
all individual param constraints are satisfied and all dependencies are satisfied.
Params for which dependencies are not satisfied should not be part of \code{x}.
Constraints and dependencies are not checked when \code{check_strict} is \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$check(xs, check_strict = TRUE, sanitize = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{(named \code{list()}).}

\item{\code{check_strict}}{(\code{logical(1)})\cr
Whether to check that constraints and dependencies are satisfied.}

\item{\code{sanitize}}{(\code{logical(1)})\cr
Whether to move values that are slightly outside bounds to valid values.
These values are accepted independent of \code{sanitize} (depending on the
\code{tolerance} arguments of \code{p_dbl()} and \code{p_int()}) . If \code{sanitize}
is \code{TRUE}, the additional effect is that, should checks pass, the
sanitized values of \code{xs} are added to the result as attribute \code{"sanitized"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not a string with an error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-check_dependencies"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-check_dependencies}{}}}
\subsection{Method \code{check_dependencies()}}{
\pkg{checkmate}-like check-function. Takes a named list.
Checks that all individual param dependencies are satisfied.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$check_dependencies(xs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{(named \code{list()}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not a string with an error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-test"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-test}{}}}
\subsection{Method \code{test()}}{
\pkg{checkmate}-like test-function. Takes a named list.
A point x is feasible, if it configures a subset of params,
all individual param constraints are satisfied and all dependencies are satisfied.
Params for which dependencies are not satisfied should not be part of \code{x}.
Constraints and dependencies are not checked when \code{check_strict} is \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$test(xs, check_strict = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{(named \code{list()}).}

\item{\code{check_strict}}{(\code{logical(1)})\cr
Whether to check that constraints and dependencies are satisfied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not \code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-assert"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-assert}{}}}
\subsection{Method \code{assert()}}{
\pkg{checkmate}-like assert-function. Takes a named list.
A point x is feasible, if it configures a subset of params,
all individual param constraints are satisfied and all dependencies are satisfied.
Params for which dependencies are not satisfied should not be part of \code{x}.
Constraints and dependencies are not checked when \code{check_strict} is \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$assert(
  xs,
  check_strict = TRUE,
  .var.name = vname(xs),
  sanitize = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{(named \code{list()}).}

\item{\code{check_strict}}{(\code{logical(1)})\cr
Whether to check that constraints and dependencies are satisfied.}

\item{\code{.var.name}}{(\code{character(1)})\cr
Name of the checked object to print in error messages.\cr
Defaults to the heuristic implemented in \link[checkmate:vname]{vname}.}

\item{\code{sanitize}}{(\code{logical(1)})\cr
Whether to move values that are slightly outside bounds to valid values.
These values are accepted independent of \code{sanitize} (depending on the
\code{tolerance} arguments of \code{p_dbl()} and \code{p_int()}) . If \code{sanitize}
is \code{TRUE}, the additional effect is that \code{xs} is converted to within bounds.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{xs} invisibly, if not an error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-check_dt"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-check_dt}{}}}
\subsection{Method \code{check_dt()}}{
\pkg{checkmate}-like check-function. Takes a \link[data.table:data.table]{data.table::data.table}
where rows are points and columns are parameters.
A point x is feasible, if it configures a subset of params,
all individual param constraints are satisfied and all dependencies are satisfied.
Params for which dependencies are not satisfied should not be part of \code{x}.
Constraints and dependencies are not checked when \code{check_strict} is \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$check_dt(xdt, check_strict = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\link[data.table:data.table]{data.table::data.table} | \code{data.frame()}).}

\item{\code{check_strict}}{(\code{logical(1)})\cr
Whether to check that constraints and dependencies are satisfied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not a string with the error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-test_dt"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-test_dt}{}}}
\subsection{Method \code{test_dt()}}{
\pkg{checkmate}-like test-function (s. \verb{$check_dt()}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$test_dt(xdt, check_strict = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\link[data.table:data.table]{data.table::data.table}).}

\item{\code{check_strict}}{(\code{logical(1)})\cr
Whether to check that constraints and dependencies are satisfied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not \code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-assert_dt"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-assert_dt}{}}}
\subsection{Method \code{assert_dt()}}{
\pkg{checkmate}-like assert-function (s. \verb{$check_dt()}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$assert_dt(xdt, check_strict = TRUE, .var.name = vname(xdt))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\link[data.table:data.table]{data.table::data.table}).}

\item{\code{check_strict}}{(\code{logical(1)})\cr
Whether to check that constraints and dependencies are satisfied.}

\item{\code{.var.name}}{(\code{character(1)})\cr
Name of the checked object to print in error messages.\cr
Defaults to the heuristic implemented in \link[checkmate:vname]{vname}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{xs} invisibly, if not, an error is generated.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-qunif"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-qunif}{}}}
\subsection{Method \code{qunif()}}{
Map a \code{matrix} or \code{data.frame} of values between 0 and 1 to proportional values inside the feasible intervals of individual parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$qunif(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{matrix} | \code{data.frame})\cr
Values to map. Column names must be a subset of the names of parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-get_domain"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-get_domain}{}}}
\subsection{Method \code{get_domain()}}{
get the \code{\link{Domain}} object that could be used to create a given parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$get_domain(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Domain}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-subset"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-subset}{}}}
\subsection{Method \code{subset()}}{
Create a new \code{ParamSet} restricted to the passed IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$subset(
  ids,
  allow_dangling_dependencies = FALSE,
  keep_constraint = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character()}).}

\item{\code{allow_dangling_dependencies}}{(\code{logical(1)})\cr
Whether to allow subsets that cut across parameter dependencies.
Dependencies that point to dropped parameters are kept (but will be "dangling", i.e. their \code{"on"} will not be present).}

\item{\code{keep_constraint}}{(\code{logical(1)})\cr
Whether to keep the \verb{$constraint} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ParamSet}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-subspaces"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-subspaces}{}}}
\subsection{Method \code{subspaces()}}{
Create new one-dimensional \code{ParamSet}s for each dimension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$subspaces(ids = private$.params$id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character()})\cr
IDs for which to create \code{ParamSet}s. Defaults to all IDs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named \code{list()} of \code{ParamSet}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-flatten"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-flatten}{}}}
\subsection{Method \code{flatten()}}{
Create a \code{ParamSet} from this object, even if this object itself is not
a \code{ParamSet} but e.g. a \code{\link{ParamSetCollection}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$flatten()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-search_space"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-search_space}{}}}
\subsection{Method \code{search_space()}}{
Construct a \code{\link{ParamSet}} to tune over. Constructed from \code{\link{TuneToken}} in \verb{$values}, see \code{\link[=to_tune]{to_tune()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$search_space(values = self$values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{(\verb{named list}): optional named list of \code{\link{TuneToken}} objects to convert, in place of \verb{$values}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-add_dep"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-add_dep}{}}}
\subsection{Method \code{add_dep()}}{
Adds a dependency to this set, so that param \code{id} now depends on param \code{on}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$add_dep(id, on, cond, allow_dangling_dependencies = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)}).}

\item{\code{on}}{(\code{character(1)}).}

\item{\code{cond}}{(\link{Condition}).}

\item{\code{allow_dangling_dependencies}}{(\code{logical(1)}): Whether to allow dependencies on parameters that are not present.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-format"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$format()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-print"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$print(
  ...,
  hide_cols = c("levels", "is_bounded", "special_vals", "tags", "storage_type")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}

\item{\code{hide_cols}}{(\code{character()})\cr
Which fields should not be printed? Default is \code{"levels"},
\code{"is_bounded"}, \code{"special_vals"}, \code{"tags"}, and \code{"storage_type"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
