% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Specification.R
\name{Specification}
\alias{Specification}
\title{Specification}
\description{
This class contains the information required to start a backend. An instance
of this class is used by the \code{start} method of the
\code{\link{BackendService}} interface.
}
\examples{
# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 4)

# Set the cluster type.
specification$set_type(type = "psock")

# Get the number of cores.
specification$cores

# Get the cluster type.
specification$type

# Attempt to set too many cores.
specification$set_cores(cores = 100)

# Check that the cores were reasonably set.
specification$cores

# Allow the object to determine the adequate cluster type.
specification$set_type(type = NULL)

# Check the type determined.
specification$type

# Attempt to set an invalid cluster type.
specification$set_type(type = "invalid")

# Check that the type was set to `psock`.
specification$type

}
\seealso{
\code{\link{BackendService}}, \code{\link{Backend}}, \code{\link{SyncBackend}},
and \code{\link{AsyncBackend}}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{cores}}{The number of nodes to use in the cluster creation.}

\item{\code{type}}{The type of cluster to create.}

\item{\code{types}}{The supported cluster types.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Specification-set_cores}{\code{Specification$set_cores()}}
\item \href{#method-Specification-set_type}{\code{Specification$set_type()}}
\item \href{#method-Specification-clone}{\code{Specification$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Specification-set_cores"></a>}}
\if{latex}{\out{\hypertarget{method-Specification-set_cores}{}}}
\subsection{Method \code{set_cores()}}{
Set the number of nodes to use in the cluster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Specification$set_cores(cores)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cores}}{The number of nodes to use in the cluster.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method also performs a validation of the requested number of
cores, ensuring that the the value lies between \code{1} and
\code{parallel::detectCores() - 1}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Specification-set_type"></a>}}
\if{latex}{\out{\hypertarget{method-Specification-set_type}{}}}
\subsection{Method \code{set_type()}}{
Set the type of cluster to create.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Specification$set_type(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of cluster to create. Possible values are
\code{"fork"} and \code{"psock"}. Defaults to \code{"psock"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If no type is explicitly requested (i.e., \code{type = NULL}), the type is
determined based on the operating system. On Unix-like systems, the
type is set to \code{"fork"}, while on Windows systems, the type is set to
\code{"psock"}. If an unknown type is requested, a warning is issued and
the type is set to \code{"psock"}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Specification-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Specification-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Specification$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
