% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.r
\name{par_sapply}
\alias{par_sapply}
\title{Run a Task in Parallel}
\usage{
par_sapply(backend = NULL, x, fun, ...)
}
\arguments{
\item{backend}{An object of class \code{\link{Backend}} as returned by the
\code{\link[=start_backend]{start_backend()}} function. It can also be \code{NULL} to run the task
sequentially via \code{\link[base:lapply]{base::sapply()}}. The default value is \code{NULL}.}

\item{x}{An atomic vector or list to pass to the \code{fun} function.}

\item{fun}{A function to apply to each element of \code{x}.}

\item{...}{Additional arguments to pass to the \code{fun} function.}
}
\value{
A vector of the same length as \code{x} containing the results of the \code{fun}. The
output format resembles that of \code{\link[base:lapply]{base::sapply()}}.
}
\description{
This function can be used to run a task in parallel. The task is executed in
parallel on the specified backend, similar to \code{\link[parallel:clusterApply]{parallel::parSapply()}}. If
\code{backend = NULL}, the task is executed sequentially using \code{\link[base:lapply]{base::sapply()}}.
See the \strong{Details} section for more information on how this function works.
}
\details{
This function uses the \code{\link{UserApiConsumer}} class that acts like an
interface for the developer API of the \code{\link{parabar}} package.
}
\examples{
\donttest{

# Define a simple task.
task <- function(x) {
    # Perform computations.
    Sys.sleep(0.01)

    # Return the result.
    return(x + 1)
}

# Start an asynchronous backend.
backend <- start_backend(cores = 2, cluster_type = "psock", backend_type = "async")

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Disable progress tracking.
set_option("progress_track", FALSE)

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Enable progress tracking.
set_option("progress_track", TRUE)

# Change the progress bar options.
configure_bar(type = "modern", format = "[:bar] :percent")

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Stop the backend.
stop_backend(backend)

# Start a synchronous backend.
backend <- start_backend(cores = 2, cluster_type = "psock", backend_type = "sync")

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Disable progress tracking to remove the warning that progress is not supported.
set_option("progress_track", FALSE)

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Stop the backend.
stop_backend(backend)

# Run the task using the `base::sapply` (i.e., non-parallel).
results <- par_sapply(NULL, x = 1:300, fun = task)

}

}
\seealso{
\code{\link[=start_backend]{start_backend()}}, \code{\link[=peek]{peek()}}, \code{\link[=export]{export()}},
\code{\link[=evaluate]{evaluate()}}, \code{\link[=clear]{clear()}}, \code{\link[=configure_bar]{configure_bar()}},
\code{\link[=par_lapply]{par_lapply()}}, \code{\link[=par_apply]{par_apply()}}, \code{\link[=stop_backend]{stop_backend()}},
\code{\link[=set_option]{set_option()}}, \code{\link[=get_option]{get_option()}}, \code{\link{Options}},
\code{\link{UserApiConsumer}}, and \code{\link{Service}}.
}
