% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_date.R
\name{span_date}
\alias{span_date}
\title{Wrapper around \code{seq.Date}.}
\usage{
span_date(from, to = NULL, len_out = NULL, by = NULL)
}
\arguments{
\item{from}{Integer or character of length 4 (yyyy), 6 (yyyymm), or 8
(yyymmdd). Indicating the start value of the sequence.}

\item{to}{Integer or character of length 4 (yyyy), 6 (yyyymm), or 8
(yyymmdd). Optional.}

\item{len_out}{The desired length of the sequence. Optional.}

\item{by}{The desired interval. Optional.}
}
\value{
An object of class Date.
}
\description{
Quickly create a sequence of dates from minimal specifications.
}
\details{
Minimal specification of dates, sets unspecified date parts to
default values. These are 01 for both month and day.

In addition to \code{from}, either \code{to} or \code{len_out} must be specified.
If \code{by} is not specified, \code{span_date} will set the interval to the
highest of the specified date parts in either \code{from} or \code{to}.
For example, if they are 2011 and 2015 it will be "year", if they are 2011
and 201501 it will be "month".
}
\examples{
# using "to" argument
span_date(2011, 2015)
span_date(201101, 201501)
span_date(2011, 2015, by = "month")
span_date(2011, 201501)
span_date(20111225, 2012)

# using "len_out" argument
span_date(2011, len_out = 4)
span_date(201101, len_out = 4)
span_date(20110101, len_out = 4)
span_date(20110101, len_out = 4, by = "month")
}
