% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InfinitySparseMatrix.R
\name{dbind}
\alias{dbind}
\title{Diagonally bind together subgroup-specific distances}
\usage{
dbind(..., force_unique_names = FALSE)
}
\arguments{
\item{...}{Any number of distance objects which can be converted to
\code{InfinitySparseMatrix}, such as class \code{matrix},
\code{DenseMatrix}, \code{InfinitySparseMatrix}, or
\code{BlockedInfinitySparseMatrix}, or \code{list}s containing distance
objects.}

\item{force_unique_names}{Default \code{FALSE}. When row or column names are
not unique among all distances, if \code{FALSE}, throw a warning and
rename all rows and columns to ensure unique names. If \code{TRUE}, error
on non-unique names.}
}
\value{
A \code{BlockedInfinitySparseMatrix} containing a block-diagonal
  distance matrix. If only a single distance is passed to \code{dbind} and
  it is not already a \code{BlockedInfinitySparseMatrix}, the result will be
  an \code{InfinitySparseMatrix} instead.
}
\description{
This function generates a single block-diagonal distance matrix given
several distance matrices defined on subgroups.
}
\details{
When you've generated several distances matrices on subgroups in your
analysis, you may wish to combine them into a single block-diagonal distance
matrix. The \code{dbind} function facilitates this.

Any \code{BlockedInfinitySparseMatrix} include in \code{...} will be broken
into individual \code{InfinitySparseMatrix} before being joined back
together. For example, if \code{b} is a \code{BlockedInfinitySparseMatrix}
with 2 subgroups and \code{m} is a distance without subgroups, then
\code{dbind(b, m)} will be a \code{BlockedInfinitySparseMatrix} with 3
subgroups.

If there are any shared names (either row or column) among all distances
passed in, by default all matrices will be renamed to ensure unique names by
appending "X." to each distance, where "X" is ascending lower case letters
("a.", "b.", etc). Setting the \code{force_unique_names} argument to
\code{TRUE} errors on this instead.

If the matrices need to be renamed and there are more than 26 separate
matrices, after the first 26 single "X." prefixs, they will continue as
"YX.", e.g "aa.", "ab.", "ac.". If more than 676 separate matrices, the
prefix wil continue to "ZYX.", e.g. "aaa.", "aab.", "aac.". This scheme
supports up to 18,278 unique matrices.

Note that you do \strong{not} have to combine subgroup distances into a
single blocked distance using this function to ultimately obtain a single
matching set. Instead, take a look at the vignette
\code{vignette("matching-within-subgroups", package = "optmatch")} for
details on combining multiple matches.
}
\examples{
data(nuclearplants)
m1 <- match_on(pr ~ cost, data = subset(nuclearplants, pt == 0),
               caliper = 1)
m2 <- match_on(pr ~ cost, data = subset(nuclearplants, pt == 1),
               caliper = 1.3)
blocked <- dbind(m1, m2)

dists <- list(m1, m2)

blocked2 <- dbind(dists)
identical(blocked, blocked2)
}
