% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_base_colors}
\alias{wb_base_colors}
\alias{wb_set_base_colors}
\alias{wb_get_base_colors}
\alias{wb_set_base_colours}
\alias{wb_get_base_colours}
\title{Set the default colors in a workbook}
\usage{
wb_set_base_colors(wb, theme = "Office", ...)

wb_get_base_colors(wb, xml = FALSE, plot = TRUE)
}
\arguments{
\item{wb}{A workbook object}

\item{theme}{a predefined color theme}

\item{...}{optional parameters}

\item{xml}{Logical if xml string should be returned}

\item{plot}{Logical if a barplot of the colors should be returned}
}
\description{
Modify / get the default colors of the workbook.
}
\details{
Theme must be any of the following:
"Aspect", "Blue", "Blue II", "Blue Green", "Blue Warm", "Greyscale",
"Green", "Green Yellow", "Marquee", "Median", "Office", "Office 2007 - 2010",
"Office 2013 - 2022", "Orange", "Orange Red", "Paper", "Red",
"Red Orange", "Red Violet", "Slipstream", "Violet", "Violet II",
"Yellow", "Yellow Orange"
}
\examples{
wb <- wb_workbook()
wb$get_base_colors()
wb$set_base_colors(theme = 3)
wb$set_base_colors(theme = "Violet II")
wb$get_base_colours()
}
\seealso{
Other workbook styling functions: 
\code{\link{base_font-wb}},
\code{\link{wb_add_dxfs_style}()},
\code{\link{wb_add_style}()}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook styling functions}
\concept{workbook wrappers}
