% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_get_tables}
\alias{wb_get_tables}
\title{List Excel tables in a workbook}
\usage{
wb_get_tables(wb, sheet = current_sheet())
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}
}
\value{
character vector of table names on the specified sheet
}
\description{
List Excel tables in a workbook
}
\examples{

wb <- wb_workbook()
wb$add_worksheet(sheet = "Sheet 1")
wb$add_data_table(sheet = "Sheet 1", x = iris)
wb$add_data_table(sheet = 1, x = mtcars, tableName = "mtcars", startCol = 10)

wb$get_tables(sheet = "Sheet 1")
}
