% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-pure-error-anova.R
\name{ols_pure_error_anova}
\alias{ols_pure_error_anova}
\title{Lack of fit F test}
\usage{
ols_pure_error_anova(model, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other parameters.}
}
\value{
\code{ols_pure_error_anova} returns an object of class
\code{"ols_pure_error_anova"}. An object of class \code{"ols_pure_error_anova"} is a
list containing the following components:

\item{lackoffit}{lack of fit sum of squares}
\item{pure_error}{pure error sum of squares}
\item{rss}{regression sum of squares}
\item{ess}{error sum of squares}
\item{total}{total sum of squares}
\item{rms}{regression mean square}
\item{ems}{error mean square}
\item{lms}{lack of fit mean square}
\item{pms}{pure error mean square}
\item{rf}{f statistic}
\item{lf}{lack of fit f statistic}
\item{pr}{p-value of f statistic}
\item{pl}{p-value pf lack of fit f statistic}
\item{mpred}{\code{data.frame} containing data for the response and predictor of the \code{model}}
\item{df_rss}{regression sum of squares degrees of freedom}
\item{df_ess}{error sum of squares degrees of freedom}
\item{df_lof}{lack of fit degrees of freedom}
\item{df_error}{pure error degrees of freedom}
\item{final}{data.frame; contains computed values used for the lack of fit f test}
\item{resp}{character vector; name of \code{response variable}}
\item{preds}{character vector; name of \code{predictor variable}}
}
\description{
Assess how much of the error in prediction is due to lack of model fit.
}
\details{
The residual sum of squares resulting from a regression can be decomposed
into 2 components:

\itemize{
  \item Due to lack of fit
  \item Due to random variation
}

If most of the error is due to lack of fit and not just random error, the
model should be discarded and a new model must be built.
}
\note{
The lack of fit F test works only with simple linear regression.
Moreover, it is important that the data contains repeat observations i.e.
replicates for at least one of the values of the predictor x. This
test generally only applies to datasets with plenty of replicates.
}
\examples{
model <- lm(mpg ~ disp, data = mtcars)
ols_pure_error_anova(model)

}
\references{
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition).
Chicago, IL., McGraw Hill/Irwin.
}
