% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets.R
\name{subsets}
\alias{subsets}
\title{Generate vector subsets}
\usage{
subsets(v, n = seq_along(v))
}
\arguments{
\item{v}{[atomic()`]\cr
A vector of elements.}

\item{n}{[integer(1)`]\cr
The requested subset sizes.}
}
\value{
A \code{list}, each element is a subset of \code{v}.
}
\description{
This function generates subsets of a vector.
}
\examples{
v <- 1:3
subsets(v)
subsets(v, c(1, 3)) # only subsets of length 1 or 3
subsets(integer())  # trivial case works
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{insert_vector_entry}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{indexing}
