% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_images.R
\name{images_variation_request}
\alias{images_variation_request}
\title{API images: create image variation request}
\usage{
images_variation_request(
  image,
  model = NULL,
  n = NULL,
  response_format = NULL,
  size = NULL,
  user = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{image}{string/raw, the image to edit. Must be a valid PNG file, less than 4MB, and square}

\item{model}{NULL/string, the model to use for image generation. Only dall-e-2 is supported at this time.}

\item{n}{NULL/int, the number of images to generate. Must be between 1 (default) and 10.}

\item{response_format}{NULL/string, the format in which the generated images are returned. Must be one of "url" or
"b64_json".}

\item{size}{NULL/string, the size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 (default).}

\item{user}{string a unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Creates a variation of a given image. To get more details, visit
https://platform.openai.com/docs/api-reference/images/createVariation
}
