% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_trial}
\alias{simulate_trial}
\title{Simulate a clinical trial}
\usage{
simulate_trial(arm0 = NA, arm1 = NA, events = NA, duration = Inf)
}
\arguments{
\item{arm0}{object of class 'arm'.}

\item{arm1}{object of class 'arm'.}

\item{events}{number of required events to trigger end of study; overrides
study duration defined within \code{arm0} and \code{arm1}.}

\item{duration}{time from first-patient-in to trigger end of study; overrides
study duration defined within \code{arm0} and \code{arm1}. If both \code{events}
and \code{duration} are specified, end of study is triggered by either criteria,
whichever occurs first.}
}
\value{
\item{arm}{0=\code{arm0}, 1=\code{arm1}}
  \item{time.accr}{time to accrual}
  \item{time.obs}{time to observation from accrual}
  \item{time.total}{time to observation from start of study}
  \item{censor}{0=censor, 1=event}
  \item{reason}{event description ('[experience ]event', '[loss to ]followup', 'administration[ censoring]')}
}
\description{
Simulate a single- or two-arm clinical trial, where end of study (EOS)
is triggered after a number of events has been observed or a certain time
has elapsed. Whereas \code{simulate_arm} provides complete data for patients,
including time to event and loss of follow-up, \code{simulate_trial} mimicks
an actual survival study by providing only the observed time (minimum of time
to event or censoring) and censoring indicator.
}
\examples{
arm0 <- create_arm(size=120, accr_time=6, surv_scale=0.05, loss_scale=0.005, follow_time=12)
arm1 <- create_arm(size=120, accr_time=6, surv_scale=0.03, loss_scale=0.005, follow_time=12)
simulate_trial(arm0, duration=10)
simulate_trial(arm0, arm1, events=50)
}
\seealso{
\code{\link{simulate_arm}} for simulating complete data for a single
arm, \code{\link{create_arm}} for creating an object of class 'arm'.
}
