% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/038_sym_def_ln.R
\name{sym_def_ln}
\alias{sym_def_ln}
\alias{sym_def_ln.default}
\alias{sym_def_ln.formula}
\title{Symmetric default label noise}
\usage{
\method{sym_def_ln}{default}(x, y, level, def = 1, order = levels(y), sortid = TRUE, ...)

\method{sym_def_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{def}{an integer with the index of the default class (default: 1).}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric default label noise} into a classification dataset.
}
\details{
\emph{Symmetric default label noise} randomly selects (\code{level}·100)\% of the samples
in the dataset with independence of their class. Then, the labels of these samples are
replaced by a fixed label (\code{def}) within the set of class labels. 
The index \code{def} is taken according to the order given by \code{order}.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_def_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                     level = 0.1, order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_def_ln(formula = Species ~ ., data = iris2D,
                     level = 0.1, order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
M. Ren, W. Zeng, B. Yang, and R. Urtasun. \strong{Learning to reweight examples for robust 
deep learning}. In \emph{Proc. 35th International Conference on Machine Learning}, 
volume 80 of PMLR, pages 4331-4340, 2018.
url:\url{http://proceedings.mlr.press/v80/ren18a.html}.
}
\seealso{
\code{\link{sym_ddef_ln}}, \code{\link{sym_exc_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
