% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/022_nei_bor_ln.R
\name{nei_bor_ln}
\alias{nei_bor_ln}
\alias{nei_bor_ln.default}
\alias{nei_bor_ln.formula}
\title{Neighborwise borderline label noise}
\usage{
\method{nei_bor_ln}{default}(x, y, level, k = 1, sortid = TRUE, ...)

\method{nei_bor_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{k}{an integer with the number of nearest neighbors to be used (default: 1).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Neighborwise borderline label noise} into a classification dataset.
}
\details{
For each sample in the dataset, \emph{Neighborwise borderline label noise} computes the
ratio of two distances: the distance to its nearest neighbor from the same
class and the distance to its nearest neighbor from another class. Then,
these values are ordered in descending order and the first (\code{level}·100)\% of them are used to determine the noisy samples. 
For each noisy sample, the majority class among its \code{k}-nearest neighbors of a different class 
is chosen as the new label.
}
\note{
Noise model adapted from the papers in References, considering a mislabeling process 
using the neighborhood of noisy samples.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- nei_bor_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- nei_bor_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
L. P. F. Garcia, J. Lehmann, A. C. P. L. F. de Carvalho, and A. C. Lorena. 
\strong{New label noise injection methods for the evaluation of noise filters.} 
\emph{Knowledge-Based Systems}, 163:693–704, 2019.
\doi{10.1016/j.knosys.2018.09.031}.
}
\seealso{
\code{\link{ulap_bor_ln}}, \code{\link{lap_bor_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
