% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/020_mis_pre_ln.R
\name{mis_pre_ln}
\alias{mis_pre_ln}
\alias{mis_pre_ln.default}
\alias{mis_pre_ln.formula}
\title{Misclassification prediction label noise}
\usage{
\method{mis_pre_ln}{default}(x, y, sortid = TRUE, ...)

\method{mis_pre_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Misclassification prediction label noise} into a classification dataset.
}
\details{
\emph{Misclassification prediction label noise} creates a Multi-Layer Perceptron (MLP) model from the dataset and relabels each
sample with the class predicted by the classifier.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- mis_pre_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)])

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- mis_pre_ln(formula = Species ~ ., data = iris2D)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
Q. Wang, B. Han, T. Liu, G. Niu, J. Yang, and C. Gong. 
\strong{Tackling instance-dependent label noise via a universal probabilistic model}. 
In \emph{Proc. 35th AAAI Conference on Artificial Intelligence}, pages 10183-10191, 2021.
url:\url{https://ojs.aaai.org/index.php/AAAI/article/view/17221}.
}
\seealso{
\code{\link{smam_bor_ln}}, \code{\link{nlin_bor_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
