% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuEST_wrappers.R
\name{lambda_estimate}
\alias{lambda_estimate}
\title{Generate sample eigenvalues from population eigenvalues}
\usage{
lambda_estimate(tau, n)
}
\arguments{
\item{tau}{(Required) A non-negative numeric vector of population
eigenvalues.}

\item{n}{(Required) A positive integer representing the number of datapoints
of a hypothetical data matrix with dimension \code{c(n, p = length(tau))}.}
}
\value{
A numeric vector of the same length as \code{tau}, containing the
  sample eigenvalue estimates, sorted in ascending order.
}
\description{
The Marcenko Pastur (MP) law relates the limiting distribution
  of the sample eigenvalues to that of the population eigenvalues. In the
  finite-dimensional case, the population spectral distribution (PSD) can be
  represented as a sum of point masses, and the empirical spectral
  distribution (ESD) can be obtained by solving the discretized MP equation.
  The QuEST function(see references), uses the quantile function of the ESD
  to compute the sample eigenvalues for any given ratio \eqn{c = p/n \in
  (0,\infty)}.
}
\examples{
lambda_estimate(tau = rep(1,200), n = 300)
}
\references{
\itemize{ \item Ledoit, O. and Wolf, M. (2015). Spectrum
  estimation: a unified framework for covariance matrix estimation and PCA in
  large dimensions. Journal of Multivariate Analysis, 139(2) \item Ledoit, O.
  and Wolf, M. (2016). Numerical Implementation of the QuEST function.
  arXiv:1601.05870 [stat.CO] }
}

