% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-nlist.R, R/as-nlists.R
\name{as_nlist}
\alias{as_nlist}
\alias{as.nlist}
\alias{as_nlist.numeric}
\alias{as_nlist.list}
\alias{as_nlist.data.frame}
\alias{as_nlist.mcmc}
\alias{as_nlist.mcmc.list}
\alias{as.nlists}
\title{Coerce to nlist}
\usage{
as_nlist(x, ...)

as.nlist(x, ...)

\method{as_nlist}{numeric}(x, ...)

\method{as_nlist}{list}(x, ...)

\method{as_nlist}{data.frame}(x, ...)

\method{as_nlist}{mcmc}(x, ...)

\method{as_nlist}{mcmc.list}(x, ...)

as.nlists(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Unused.}
}
\value{
An nlist object.
}
\description{
Coerce an R object to an \code{\link[=nlist_object]{nlist_object()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: Coerce named numeric vector to nlist

\item \code{list}: Coerce list to nlist

\item \code{data.frame}: Coerce data.frame to nlist

\item \code{mcmc}: Coerce mcmc (with one iteration) to nlist

\item \code{mcmc.list}: Coerce mcmc.list (with one iteration) to nlist
}}

\examples{
as_nlist(list(x = 1:4))
as_nlist(c(`a[2]` = 3, `a[1]` = 2))
}
\seealso{
Other coerce: 
\code{\link{as_nlists}()}
}
\concept{coerce}
