% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgrd.R
\name{sgrd}
\alias{sgrd}
\alias{dsgrd}
\alias{psgrd}
\alias{qsgrd}
\alias{rsgrd}
\title{Slashed Generalized Rayleigh Distribution}
\usage{
dsgrd(x, theta, alpha, beta, log = FALSE)

psgrd(q, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qsgrd(p, theta, alpha, beta, lower.tail = TRUE)

rsgrd(n, theta, alpha, beta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a scale parameter.}

\item{alpha}{a shape parameter.}

\item{beta}{a kurtosis parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dsgrd} gives the density, \code{psgrd} gives the distribution
function, \code{qsgrd} gives the quantile function and \code{rsgrd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Slashed generalized Rayleigh distribution with parameters \code{shape},
\code{scale} and \code{kurtosis}.
}
\details{
The Slashed Generalized Rayleigh distribution with \code{shape} parameter
\eqn{\alpha}, \code{scale} parameter \eqn{\theta} and \code{kurtosis}
parameter \eqn{\beta}, has density
\deqn{f\left( x\right) =\frac{\beta x^{-\left( \beta+1\right)}}{\Gamma \left(
\alpha+1\right) \theta ^{\beta/2}}\Gamma \left( \frac{2\alpha +\beta +2}{2}
\right)F\left( \theta x^{2};\frac{2\alpha +\beta +2}{2},1\right), }
where F(.;a,b) is the cdf of the Gamma (a,b) distribution, and
\deqn{x>0,~\theta >0,~\alpha >-1~and~\beta >0}
}
\examples{
library(new.dist)
dsgrd(2,theta=3,alpha=1,beta=4)
psgrd(5,theta=3,alpha=1,beta=4)
qsgrd(.4,theta=3,alpha=1,beta=4)
rsgrd(10,theta=3,alpha=1,beta=4)
}
\references{
Iriarte, Y. A., Vilca, F., Varela, H. ve Gómez, H. W., 2017,
\emph{Slashed generalized Rayleigh distribution}, Communications in Statistics-
Theory and Methods, 46 (10), 4686-4699.
}
