% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ld.R
\name{Ld}
\alias{Ld}
\alias{dLd}
\alias{pLd}
\alias{qLd}
\alias{rLd}
\title{Lindley Distribution}
\usage{
dLd(x, theta, log = FALSE)

pLd(q, theta, lower.tail = TRUE, log.p = FALSE)

qLd(p, theta, lower.tail = TRUE)

rLd(n, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dLd} gives the density, \code{pLd} gives the distribution
function, \code{qLd} gives the quantile function and \code{rLd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Lindley distribution.
}
\details{
The Lindley distribution with a parameter \eqn{\theta}, has density
\deqn{f\left( x\right) =\frac{\theta ^{2}}{1+\theta }\left( 1+x\right)
e^{-\theta~x},}
where
\deqn{x>0,~\theta >0.}
}
\examples{
library(new.dist)
dLd(1,theta=2)
pLd(1,theta=2)
qLd(.8,theta=1)
rLd(10,theta=1)
}
\references{
Akgül, F. G., Acıtaş, Ş. ve Şenoğlu, B., 2018,
\emph{Inferences on stress–strength reliability based on ranked set sampling data
in case of Lindley distribution}, Journal of statistical computation and
simulation, 88 (15), 3018-3032.
}
