% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{plot.cv.ncpen}
\alias{plot.cv.ncpen}
\title{plot.cv.ncpen: plot cross-validation error curve.}
\usage{
\method{plot}{cv.ncpen}(x, type = c("rmse", "like"), log.scale = FALSE,
  ...)
}
\arguments{
\item{x}{fitted \code{cv.ncpen} object.}

\item{type}{(character) a cross-validated error type which is either \code{rmse} or \code{like}.}

\item{log.scale}{(logical) whether to use log scale of lambda for horizontal axis.}

\item{...}{other graphical parameters to \code{\link{plot}}}
}
\description{
The function Produces a plot of the cross-validated errors from \code{cv.ncpen} object.
}
\examples{
### linear regression with scad penalty
par(mfrow=c(1,2))
sam =  sam.gen.ncpen(n=500,p=10,q=5,cf.min=0.5,cf.max=1,corr=0.5,family="gaussian")
x.mat = sam$x.mat; y.vec = sam$y.vec
fit = cv.ncpen(y.vec=y.vec,x.mat=x.mat,n.lambda=50,family="gaussian", penalty="scad")
plot(fit)
plot(fit,log.scale=F)

}
\references{
Lee, S., Kwon, S. and Kim, Y. (2016). A modified local quadratic approximation algorithm for penalized optimization problems.
\emph{Computational Statistics and Data Analysis}, 94, 275-286.
}
\seealso{
\code{\link{cv.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
