% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nardl.R
\name{nardl}
\alias{nardl}
\title{Nonlinear ARDL function}
\usage{
nardl(formula, data, ic = c("aic", "bic"), maxlag = 4, graph = FALSE, case = 3)
}
\arguments{
\item{formula}{food~inf or food~inf|I(inf^2)}

\item{data}{the dataframe}

\item{ic}{: c("aic","bic") criteria model selection}

\item{maxlag}{maximum lag number}

\item{graph}{TRUE to show stability tests plot}

\item{case}{case number 3 for (unrestricted intercert, no trend) and 5 (unrestricted intercept, unrestricted trend), 1 2 and 4 not supported}
}
\description{
Nonlinear ARDL function
}
\examples{

############################################
# Fit the nonlinear cointegrating autoregressive distributed lag model
############################################
# Load data
data(fod)
############################################
# example 1:auto selected lags (maxlags=TRUE)
############################################
reg<-nardl(food~inf,fod,ic="aic",maxlag = 4,graph = FALSE,case=3)
summary(reg)

############################################
# example 2: Cusum and CusumQ plot (graph=TRUE)
############################################
reg<-nardl(food~inf,fod,ic="aic",maxlag = 4,graph = TRUE,case=3)

}
