% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(
  url,
  async = FALSE,
  convert = TRUE,
  follow = FALSE,
  method = NULL,
  headers = NULL,
  data = NULL,
  response = NULL,
  timeout = NULL,
  tls = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{async}{[default FALSE] logical value whether to perform an async request,
in which case an 'ncurlAio' is returned instead of a list.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vector. Supplying a non-logical
value will error.}

\item{follow}{[default FALSE] logical value whether to automatically follow
redirects (not applicable for async requests). If FALSE (or async), the
redirect address is returned as response header 'Location'. Supplying
a non-logical value will error.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named list or character vector specifying the
HTTP request headers e.g. \code{list(`Content-Type` = "text/plain")} or
\code{c(Authorization = "Bearer APIKEY")}. Supplying a non-named list or
vector will error.}

\item{data}{(optional) the request data to be submitted.}

\item{response}{(optional) a character vector or list specifying the response
headers to return e.g. \code{c("date", "server")} or \code{list("Date", "Server")}.
These are case-insensitive and will return NULL if not present.}

\item{timeout}{(optional) integer value in milliseconds after which the
transaction times out if not yet complete.}

\item{tls}{(optional) applicable to secure HTTPS sites only, a client TLS
Configuration object created by \code{\link{tls_config}}. If missing or
NULL, certificates are not validated.}
}
\value{
Named list of 4 elements:
    \itemize{
    \item{\code{$status}} {- integer HTTP repsonse status code (200 - OK).
    Use \code{\link{status_code}} for a translation of the meaning.}
    \item{\code{$headers}} {- named list of response headers supplied in
    'response', or NULL otherwise. If the status code is within the 300
    range, i.e. a redirect, the response header 'Location' is automatically
    appended to return the redirect address.}
    \item{\code{$raw}} {- raw vector of the received resource (use
    \code{\link{writeBin}} to save to a file).}
    \item{\code{$data}} {- converted character string (if \code{'convert' = TRUE}
    and content is a recognised text format), or NULL otherwise. This may be
    further parsed as html, json, xml etc. if required.}
    }

    Or else, if \code{async = TRUE}, an 'ncurlAio' (object of class 'ncurlAio'
    and 'recvAio') (invisibly).
}
\description{
nano cURL - a minimalist http(s) client.
}
\examples{
ncurl("https://www.r-project.org/", response = c("date", "server"), timeout = 1000L)
ncurl("https://postman-echo.com/put",
      method = "PUT",
      headers = list(Authorization = "Bearer APIKEY"),
      data = "hello world",
      timeout = 1500L)
ncurl("https://postman-echo.com/post",
      method = "POST",
      headers = c(`Content-Type` = "application/json"),
      data = '{"k":"v"}',
      timeout = 1500L)

}
