% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{signal}
\alias{signal}
\title{Signal a Condition Variable}
\usage{
signal(cv, time, flag = TRUE)
}
\arguments{
\item{cv}{a 'conditionVariable',}

\item{time}{integer number of milliseconds after which to signal the
condition variable.}

\item{flag}{[default TRUE] logical value whether to also set a flag in the
'conditionVariable'. This can help distinguish between different types of
signal, and causes any subsequent \code{\link{wait}} or \code{\link{until}}
to return FALSE instead of TRUE.}
}
\value{
Invisible NULL.
}
\description{
Creates a new thread which signals a condition variable after a specified time,
    causing its internal condition to increment by one (and threads waiting
    on the condition to wake).
}
\details{
Non-integer values for 'time' are coerced to integer, and the
    absolute value is taken (the sign is ignored). Non-numeric values are
    ignored, in which case the condition variable is signalled immediately.
}
\examples{
cv <- cv()
cv_value(cv)
start <- mclock()

signal(cv, time = 100L, flag = FALSE)
wait(cv) == TRUE
mclock() - start

signal(cv, time = 100L, flag = TRUE)
wait(cv) == FALSE
mclock() - start

}
