% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension.R
\name{nanoarrow_extension_spec}
\alias{nanoarrow_extension_spec}
\alias{register_nanoarrow_extension}
\alias{unregister_nanoarrow_extension}
\alias{resolve_nanoarrow_extension}
\title{Register Arrow extension types}
\usage{
nanoarrow_extension_spec(data = list(), subclass = character())

register_nanoarrow_extension(extension_name, extension_spec)

unregister_nanoarrow_extension(extension_name)

resolve_nanoarrow_extension(extension_name)
}
\arguments{
\item{data}{Optional data to include in the extension type specification}

\item{subclass}{A subclass for the extension type specification. Extension
methods will dispatch on this object.}

\item{extension_name}{An Arrow extension type name (e.g., arrow.r.vctrs)}

\item{extension_spec}{An extension specification inheriting from
'nanoarrow_extension_spec'.}
}
\value{
\itemize{
\item \code{nanoarrow_extension_spec()} returns an object of class
'nanoarrow_extension_spec'.
\item \code{register_nanoarrow_extension()} returns \code{extension_spec}, invisibly.
\item \code{unregister_nanoarrow_extension()} returns \code{extension_name}, invisibly.
\item \code{resolve_nanoarrow_extension()} returns an object of class
'nanoarrow_extension_spec' or NULL if the extension type was not
registered.
}
}
\description{
Register Arrow extension types
}
\examples{
nanoarrow_extension_spec("mynamespace.mytype", subclass = "mypackage_mytype_spec")
}
