% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode-proper.R
\name{mode_single}
\alias{mode_single}
\title{The single mode}
\usage{
mode_single(x, na.rm = FALSE, accept = FALSE, multiple = "NA")
}
\arguments{
\item{x}{A vector to search for its mode.}

\item{na.rm}{Boolean. Should missing values in \code{x} be removed before
computation proceeds? Default is \code{FALSE}.}

\item{accept}{Boolean. Should the minimum set of modes be accepted to check
for a single mode? If \code{FALSE} (the default), insists on the complete set
and returns \code{NA} if it can't be determined.}

\item{multiple}{String or integer (length 1), or a function. What to do if
\code{x} has multiple modes. The default returns \code{NA}. All other options rely on
the modal values: "\verb{min"}, \code{"max"}, \code{"mean"}, \code{"median"}, \code{"first"},
\code{"last"}, and \code{"random"}. Alternatively, \code{multiple} can be an index number,
or a function that summarizes the modes. See details.}
}
\value{
The only mode (most frequent value) in \code{x}. If it can't be determined
because of missing values, \code{NA} is returned instead. By default, \code{NA} is
also returned if there are multiple modes (\code{multiple = "NA"}).
}
\description{
\code{mode_single()} returns the only mode in a vector. If there are multiple
modes, it returns \code{NA} by default.
}
\details{
If \code{accept} is \code{FALSE} (the default), the set of modes is obtained
via \code{mode_all()} instead of \code{mode_possible_min()}. Set it to \code{TRUE} to
avoid returning \code{NA} when some, though not all modes are known. The purpose
of the default is to insist on a single mode.

If \code{x} is a string vector and \code{multiple} is \code{"min"} or \code{"max"}, the mode is
selected lexically, just like \code{min(letters)} returns \code{"a"}. The \code{"mean"}
and \code{"median"} options return \code{NA} with a warning. For factors, \code{"min"},
\code{"max"}, and \code{"median"} are errors, but \code{"mean"} returns \code{NA} with a
warning. These are inconsistencies in base R.

The \code{multiple} options \code{"first"} and \code{"last"} always select the mode that
appears first or last in \code{x}. Index numbers, like \code{multiple = 2}, allow you
to select more flexibly. If \code{multiple} is a function, its output must be
length 1.
}
\examples{
# `8` is the only mode:
mode_single(c(8, 8, 9))

# With more than one mode, the function
# returns `NA`:
mode_single(c(1, 2, 3, 3, 4, 4))

# Can't determine the modes here --
# `9` might be another mode:
mode_single(c(8, 8, 9, NA))

# Accept `8` anyways if it's
# sufficient to just have any mode:
mode_single(c(8, 8, 9, NA), accept = TRUE)

# `1` is the most frequent value,
# no matter what `NA` stands for:
mode_single(c(1, 1, 1, 2, NA))

# Ignore `NA`s with `na.rm = TRUE`
# (there should be good reasons for this!):
mode_single(c(8, 8, 9, NA), na.rm = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=mode_first]{mode_first()}} for the first-appearing mode.
\item \code{\link[=mode_all]{mode_all()}} for the complete set of modes.
\item \code{\link[=mode_possible_min]{mode_possible_min()}} for the minimal set of modes.
}
}
