% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{mode_count_range}
\alias{mode_count_range}
\title{Modal count range}
\usage{
mode_count_range(x, max_unique = NULL)
}
\arguments{
\item{x}{A vector to search for its possible modes.}

\item{max_unique}{Numeric or string. If the maximum number of unique values
in \code{x} is known, set \code{max_unique} to that number. This rules out that \code{NA}s
represent values beyond that number (see examples). Set it to \code{"known"}
instead if no values beyond those already known can occur. Default is
\code{NULL}, which assumes no maximum.}
}
\value{
Integer (length 2). Minimal and maximal number of modes (values tied
for most frequent) in \code{x}.
}
\description{
\code{mode_count_range()} determines the minimal and maximal number
of modes given the number of missing values.
}
\details{
If \code{x} is a factor, \code{max_unique} should be \code{"known"} or there is a
warning. This is because a factor's levels are supposed to include all of
its possible values.
}
\examples{
# If `NA` is `7` or `8`, that number is
# the only mode; otherwise, both numbers
# are modes:
mode_count_range(c(7, 7, 8, 8, NA))

# Same result here -- `7` is the only mode
# unless `NA` is secretly `8`, in which case
# there are two modes:
mode_count_range(c(7, 7, 7, 8, 8, NA))

# But now, there is now way for `8` to be
# as frequent as `7`:
mode_count_range(c(7, 7, 7, 7, 8, 8, NA))

# The `NA`s might form a new mode here
# if they are both, e.g., `9`:
mode_count_range(c(7, 7, 8, 8, NA, NA))

# However, if there can be no values beyond
# those already known -- `7` and `8` --
# the `NA`s can't form a new mode.
# Specify this with `max_unique = "known"`:
mode_count_range(c(7, 7, 8, 8, NA, NA), max_unique = "known")
}
