% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_skim.R
\name{datasummary_skim}
\alias{datasummary_skim}
\title{Quick overview of numeric or categorical variables}
\usage{
datasummary_skim(
  data,
  output = "default",
  type = "all",
  fmt = 1,
  title = NULL,
  notes = NULL,
  align = NULL,
  escape = TRUE,
  by = NULL,
  fun_numeric = list(Unique = NUnique, `Missing Pct.` = PercentMissing, Mean = Mean, SD =
    SD, Min = Min, Median = Median, Max = Max, Histogram = function(x) ""),
  ...
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .docx, .html, .tex, .md, .txt, .csv, .xlsx, .png, .jpg
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "typst", "data.frame", "tinytable", "gt", "kableExtra", "huxtable", "flextable", "DT", "jupyter". The "modelsummary_list" value produces a lightweight object which can be saved and fed back to the \code{modelsummary} function.
\item The "default" output format can be set to "tinytable", "kableExtra", "gt", "flextable", "huxtable", "DT", or "markdown"
\itemize{
\item If the user does not choose a default value, the packages listed above are tried in sequence.
\item Session-specific configuration: \code{options("modelsummary_factory_default" = "gt")}
\item Persistent configuration: \code{config_modelsummary(output = "markdown")}
}
\item Warning: Users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages. See the 'Details' section.
\item LaTeX compilation requires the \code{booktabs} and \code{siunitx} packages, but \code{siunitx} can be disabled or replaced with global options. See the 'Details' section.
}}

\item{type}{String. Variables to summarize: "all", "numeric", "categorical", "dataset"}

\item{fmt}{how to format numeric values: integer, user-supplied function, or \code{modelsummary} function.
\itemize{
\item Integer: Number of decimal digits
\item User-supplied functions:
\itemize{
\item Any function which accepts a numeric vector and returns a character vector of the same length.
}
\item \code{modelsummary} functions:
\itemize{
\item \code{fmt = fmt_significant(2)}: Two significant digits (at the term-level)
\item \code{fmt = fmt_sprintf("\%.3f")}: See \code{?sprintf}
\item \code{fmt = fmt_identity()}: unformatted raw values
}
}}

\item{title}{string. Cross-reference labels should be added with Quarto or Rmarkdown chunk options when applicable. When saving standalone LaTeX files, users can add a label such as \verb{\\\\label\{tab:mytable\}} directly to the title string, while also specifying \code{escape=FALSE}.}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A string with a number of characters equal to the number of columns in
the table (e.g., \code{align = "lcc"}).  Valid characters: l, c, r, d.
\itemize{
\item "l": left-aligned column
\item "c": centered column
\item "r": right-aligned column
\item "d": dot-aligned column. For LaTeX/PDF output, this option requires at least version 3.0.25 of the siunitx LaTeX package. See the LaTeX preamble help section below for commands to insert in your LaTeX preamble.
}}

\item{escape}{boolean TRUE escapes or substitutes LaTeX/HTML characters which could
prevent the file from compiling/displaying. \code{TRUE} escapes all cells, captions, and notes. Users can have more fine-grained control by setting \code{escape=FALSE} and using an external command such as: \code{modelsummary(model, "latex") |> tinytable::format_tt(tab, j=1:5, escape=TRUE)}}

\item{by}{Character vector of grouping variables to compute statistics over.}

\item{fun_numeric}{Named list of funtions to apply to each column of \code{data}. If \code{fun_numeric} includes "Histogram" or "Density", inline plots are inserted.}

\item{...}{all other arguments are passed through to the table-making
functions \link[tinytable:tt]{tinytable::tt}, \link[kableExtra:kbl]{kableExtra::kbl}, \link[gt:gt]{gt::gt}, \link[DT:datatable]{DT::datatable}, etc. depending on the \code{output} argument.
This allows users to pass arguments directly to \code{datasummary} in order to
affect the behavior of other functions behind the scenes.}
}
\description{
This function was inspired by the excellent \code{skimr} package for R.
See the Details and Examples sections below, and the vignettes on the
\code{modelsummary} website:
\itemize{
\item https://modelsummary.com/
\item https://modelsummary.com/articles/datasummary.html
}
}
\section{Global Options}{


The behavior of \code{modelsummary} can be modified by setting global options. For example:
\itemize{
\item \code{options(modelsummary_model_labels = "roman")}
}

The rest of this section describes each of the options above.
\subsection{Model labels: default column names}{

These global option changes the style of the default column headers:
\itemize{
\item \code{options(modelsummary_model_labels = "roman")}
\item \code{options(modelsummary_panel_labels = "roman")}
}

The supported styles are: "model", "panel", "arabic", "letters", "roman", "(arabic)", "(letters)", "(roman)"

The panel-specific option is only used when \code{shape="rbind"}
}

\subsection{Table-making packages}{

\code{modelsummary} supports 6 table-making packages: \code{tinytable}, \code{kableExtra}, \code{gt},
\code{flextable}, \code{huxtable}, and \code{DT}. Some of these packages have overlapping
functionalities. To change the default backend used for a specific file
format, you can use ' the \code{options} function:

\code{options(modelsummary_factory_html = 'kableExtra')}
\code{options(modelsummary_factory_word = 'huxtable')}
\code{options(modelsummary_factory_png = 'gt')}
\code{options(modelsummary_factory_latex = 'gt')}
\code{options(modelsummary_factory_latex_tabular = 'kableExtra')}
}

\subsection{Table themes}{

Change the look of tables in an automated and replicable way, using the \code{modelsummary} theming functionality. See the vignette: https://modelsummary.com/articles/appearance.html
\itemize{
\item \code{modelsummary_theme_gt}
\item \code{modelsummary_theme_kableExtra}
\item \code{modelsummary_theme_huxtable}
\item \code{modelsummary_theme_flextable}
\item \code{modelsummary_theme_dataframe}
}
}

\subsection{Model extraction functions}{

\code{modelsummary} can use two sets of packages to extract information from
statistical models: the \code{easystats} family (\code{performance} and \code{parameters})
and \code{broom}. By default, it uses \code{easystats} first and then falls back on
\code{broom} in case of failure. You can change the order of priorities or include
goodness-of-fit extracted by \emph{both} packages by setting:

\code{options(modelsummary_get = "easystats")}

\code{options(modelsummary_get = "broom")}

\code{options(modelsummary_get = "all")}
}

\subsection{Formatting numeric entries}{

By default, LaTeX tables enclose all numeric entries in the \verb{\\num\{\}} command
from the siunitx package. To prevent this behavior, or to enclose numbers
in dollar signs (for LaTeX math mode), users can call:

\code{options(modelsummary_format_numeric_latex = "plain")}

\code{options(modelsummary_format_numeric_latex = "mathmode")}

A similar option can be used to display numerical entries using MathJax in
HTML tables:

\code{options(modelsummary_format_numeric_html = "mathjax")}
}
}

\section{LaTeX preamble}{


When creating LaTeX via the \code{tinytable} backend (default in version 2.0.0 and later), it is useful to include the following commands in the LaTeX preamble of your documents. Note that they are added automatically when compiling Rmarkdown or Quarto documents (except when the \code{modelsummary()} calls are cached).

\if{html}{\out{<div class="sourceCode latex">}}\preformatted{\\usepackage\{tabularray\}
\\usepackage\{float\}
\\usepackage\{graphicx\}
\\usepackage[normalem]\{ulem\}
\\UseTblrLibrary\{booktabs\}
\\UseTblrLibrary\{siunitx\}
\newcommand{\tinytableTabularrayUnderline}[1]\{\\underline\{#1\}\}
\newcommand{\tinytableTabularrayStrikeout}[1]\{\\sout\{#1\}\}
\\NewTableCommand\{\\tinytableDefineColor\}[3]\{\\definecolor\{#1\}\{#2\}\{#3\}\}
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dat <- mtcars
dat$vs <- as.logical(dat$vs)
dat$cyl <- as.factor(dat$cyl)
datasummary_skim(dat)
datasummary_skim(dat, type = "categorical")
\dontshow{\}) # examplesIf}
}
\references{
Arel-Bundock V (2022). “modelsummary: Data and Model Summaries in R.” \emph{Journal of Statistical Software}, \emph{103}(1), 1-23. \doi{10.18637/jss.v103.i01}.'
}
