% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_struct.R
\name{as.cov_struct}
\alias{as.cov_struct}
\alias{as.cov_struct.formula}
\title{Coerce into a Covariance Structure Definition}
\usage{
as.cov_struct(x, ...)

\method{as.cov_struct}{formula}(x, warn_partial = TRUE, ...)
}
\arguments{
\item{x}{an object from which to derive a covariance structure. See object
specific sections for details.}

\item{...}{additional arguments unused.}

\item{warn_partial}{(\code{flag})\cr whether to emit a warning when parts of the
formula are disregarded.}
}
\value{
A \code{\link[=cov_struct]{cov_struct()}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
}
\details{
A covariance structure can be parsed from a model definition formula or call.
Generally, covariance structures defined using non-standard evaluation take
the following form:

\if{html}{\out{<div class="sourceCode">}}\preformatted{type( (visit, )* visit | (group /)? subject )
}\if{html}{\out{</div>}}

For example, formulas may include terms such as

\if{html}{\out{<div class="sourceCode r">}}\preformatted{us(time | subject)
cp(time | group / subject)
sp_exp(coord1, coord2 | group / subject)
}\if{html}{\out{</div>}}

Note that only \code{sp_exp} (spatial) covariance structures may provide multiple
coordinates, which identify the Euclidean distance between the time points.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.cov_struct(formula)}: When provided a formula, any specialized functions are assumed to be
covariance structure definitions and must follow the form:

\if{html}{\out{<div class="sourceCode">}}\preformatted{y ~ xs + type( (visit, )* visit | (group /)? subject )
}\if{html}{\out{</div>}}

Any component on the right hand side of a formula is considered when
searching for a covariance definition.

}}
\examples{
# provide a covariance structure as a right-sided formula
as.cov_struct(~ csh(visit | group / subject))

# when part of a full formula, suppress warnings using `warn_partial = FALSE`
as.cov_struct(y ~ x + csh(visit | group / subject), warn_partial = FALSE)

}
\seealso{
Other covariance types: 
\code{\link{cov_struct}()},
\code{\link{covariance_types}}
}
\concept{covariance types}
