% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_sbm.R
\name{sample_sbm}
\alias{sample_sbm}
\title{R/Rcpp function for sampling from a single level stochastic block model}
\usage{
sample_sbm(z, P)
}
\arguments{
\item{z}{An n x 1 vector of community labels for each node}

\item{P}{A K x K symmetric matrix of community connectivity probabilities}
}
\value{
An adjacency matrix
}
\description{
This function allows you to sample a single level stochastic block model.
}
\examples{
n = 100
K = 3
pi = rep(1/K,K)
z = sample(1:K, size = n, replace = TRUE, prob = pi)
p_in = 0.50
p_out = 0.05
P = matrix(p_out, nrow = K, ncol = K)
diag(P) = p_in
A = sample_sbm(z,P)
}
\keyword{SBM}
