% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_mlsbm.R
\name{sample_mlsbm}
\alias{sample_mlsbm}
\title{R/Rcpp function for sampling from a multilevel stochastic block model}
\usage{
sample_mlsbm(z, P, L)
}
\arguments{
\item{z}{An n x 1 vector of community labels for each node}

\item{P}{A K x K symmetric matrix of community connectivity probabilities}

\item{L}{The number of levels to sample}
}
\value{
A list of adjecency matrices -- one for each level of the MLSBM
}
\description{
This function allows you to sample a multilevel stochastic block model.
}
\examples{
n = 100
K = 3
L = 2
pi = rep(1/K,K)
z = sample(1:K, size = n, replace = TRUE, prob = pi)
p_in = 0.50
p_out = 0.05
P = matrix(p_out, nrow = K, ncol = K)
diag(P) = p_in
AL = sample_mlsbm(z,P,L)
}
\keyword{SBM}
