% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.spca.R
\name{tune.spca}
\alias{tune.spca}
\title{Tune number of selected variables for spca}
\usage{
tune.spca(
  X,
  ncomp = 2,
  nrepeat = 1,
  folds,
  test.keepX,
  center = TRUE,
  scale = TRUE,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{X}{a numeric matrix (or data frame) which provides the data for the sparse
principal components analysis. It should not contain missing values.}

\item{ncomp}{Integer, if data is complete \code{ncomp} decides the number of
components and associated eigenvalues to display from the \code{pcasvd}
algorithm and if the data has missing values, \code{ncomp} gives the number
of components to keep to perform the reconstitution of the data using the
NIPALS algorithm. If \code{NULL}, function sets \code{ncomp = min(nrow(X),
ncol(X))}}

\item{nrepeat}{Number of times the Cross-Validation process is repeated.}

\item{folds}{Number of folds in 'Mfold' cross-validation. See details.}

\item{test.keepX}{numeric vector for the different number of variables to
test from the \eqn{X} data set}

\item{center}{(Default=TRUE) Logical, whether the variables should be shifted
to be zero centered. Only set to FALSE if data have already been centered.
Alternatively, a vector of length equal the number of columns of \code{X}
can be supplied. The value is passed to \code{\link{scale}}. If the data
contain missing values, columns should be centered for reliable results.}

\item{scale}{(Default=TRUE) Logical indicating whether the variables should be
scaled to have unit variance before the analysis takes place.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object indicating the type
of parallelisation. See examples.}
}
\value{
A \code{tune.spca} object containing: \describe{ 
\item{call}{ The
  function call}
\item{choice.keepX}{The selected number of components on
  each component} 
\item{cor.comp}{The correlations between the components
  from the cross-validated studies and those from the study which used all of
  the data in training.} }
}
\description{
This function performs sparse pca and optimises the number of variables to
keep on each component using repeated cross-validation.
}
\details{
Essentially, for the first component, and for a grid of the number of
variables to select (\code{keepX}), a number of repeats and folds, data are
split to train and test and the extracted components are compared against
those from a spca model with all the data to ascertain the optimal
\code{keepX}. In order to keep at least 3 samples in each test set for
reliable scaling of the test data for comparison, \code{folds} must be <=
\code{floor(nrow(X)/3)}

The number of selected variables for the following components will then be
sequentially optimised. If the number of observations are small (e.g. < 30),
it is recommended to use Leave-One-Out Cross-Validation which can be
achieved by setting \code{folds = nrow(X)}.
}
\examples{
data("nutrimouse")
set.seed(42)
nrepeat <- 5
tune.spca.res <- tune.spca(
    X = nutrimouse$lipid,
    ncomp = 2,
    nrepeat = nrepeat,
    folds = 3,
    test.keepX = seq(5, 15, 5)
)
tune.spca.res
plot(tune.spca.res)
\dontrun{
## parallel processing using BiocParallel on repeats with more workers (cpus)
## You can use BiocParallel::MulticoreParam() on non_Windows machines 
## for faster computation
BPPARAM <- BiocParallel::SnowParam(workers = max(parallel::detectCores()-1, 2))
tune.spca.res <- tune.spca(
    X = nutrimouse$lipid,
    ncomp = 2,
    nrepeat = nrepeat,
    folds = 3,
    test.keepX = seq(5, 15, 5),
    BPPARAM = BPPARAM
)
plot(tune.spca.res)
}
}
