% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mat.rank}
\alias{mat.rank}
\title{Matrix Rank}
\usage{
mat.rank(mat, tol)
}
\arguments{
\item{mat}{a numeric matrix or data frame that can contain missing values.}

\item{tol}{positive real, the tolerance for singular values, only those with
values larger than \code{tol} are considered non-zero.}
}
\value{
The returned value is a list with components: \item{rank}{a integer
value, the matrix rank.} \item{tol}{the tolerance used for singular values.}
}
\description{
This function estimate the rank of a matrix.
}
\details{
\code{mat.rank} estimate the rank of a matrix by computing its singular
values \eqn{d[i]} (using \code{nipals}). The rank of the matrix can be
defined as the number of singular values \eqn{d[i] > 0}.

If \code{tol} is missing, it is given by
\code{tol=max(dim(mat))*max(d)*.Machine$double.eps}.
}
\examples{

## Hilbert matrix
hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
mat <- hilbert(16)
mat.rank(mat)

\dontrun{
## Hilbert matrix with missing data
idx.na <- matrix(sample(c(0, 1, 1, 1, 1), 36, replace = TRUE), ncol = 6)
m.na <- m <- hilbert(9)[, 1:6]
m.na[idx.na == 0] <- NA
mat.rank(m)
mat.rank(m.na)
}
}
\seealso{
\code{\link{nipals}}
}
\author{
Sébastien Déjean, Ignacio González, Al J Abadi
}
\keyword{algebra}
