% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVar.R
\name{plotVar}
\alias{plotVar}
\alias{plotVar.rcc}
\alias{plotVar.pls}
\alias{plotVar.spls}
\alias{plotVar.plsda}
\alias{plotVar.splsda}
\alias{plotVar.pca}
\alias{plotVar.spca}
\alias{plotVar.sgcca}
\alias{plotVar.rgcca}
\title{Plot of Variables}
\usage{
plotVar(
  object,
  comp = NULL,
  comp.select = comp,
  plot = TRUE,
  var.names = NULL,
  blocks = NULL,
  X.label = NULL,
  Y.label = NULL,
  Z.label = NULL,
  abline = TRUE,
  col,
  cex,
  pch,
  font,
  cutoff = 0,
  rad.in = 0.5,
  title = "Correlation Circle Plot",
  legend = FALSE,
  legend.title = "Block",
  style = "ggplot2",
  overlap = TRUE,
  axes.box = "all",
  label.axes.box = "both"
)
}
\arguments{
\item{object}{object of class inheriting from \code{"rcc"}, \code{"pls"},
\code{"plsda"}, \code{"spls"}, \code{"splsda"}, \code{"pca"} or
\code{"spca"}.}

\item{comp}{integer vector of length two. The components that will be used
on the horizontal and the vertical axis respectively to project the
variables. By default, comp=c(1,2) except when style='3d', comp=c(1:3)}

\item{comp.select}{for the sparse versions, an input vector indicating the
components on which the variables were selected. Only those selected
variables are displayed. By default, comp.select=comp}

\item{plot}{if TRUE (the default) then a plot is produced. If not, the
summaries which the plots are based on are returned.}

\item{var.names}{either a character vector of names for the variables to be
plotted, or \code{FALSE} for no names. If \code{TRUE}, the col names of the
first (or second) data matrix is used as names.}

\item{blocks}{for an object of class \code{"rgcca"} or \code{"sgcca"}, a
numerical vector indicating the block variables to display.}

\item{X.label}{x axis titles.}

\item{Y.label}{y axis titles.}

\item{Z.label}{z axis titles (when style = '3d').}

\item{abline}{should the vertical and horizontal line through the center be
plotted? Default set to \code{FALSE}}

\item{col}{character or integer vector of colors for plotted character and
symbols, can be of length 2 (one for each data set) or of length (p+q) (i.e.
the total number of variables). See Details.}

\item{cex}{numeric vector of character expansion sizes for the plotted
character and symbols, can be of length 2 (one for each data set) or of
length (p+q) (i.e. the total number of variables).}

\item{pch}{plot character. A vector of single characters or integers, can be
of length 2 (one for each data set) or of length (p+q) (i.e. the total
number of variables). See \code{\link{points}} for all alternatives.}

\item{font}{numeric vector of font to be used, can be of length 2 (one for
each data set) or of length (p+q) (i.e. the total number of variables). See
\code{\link{par}} for details.}

\item{cutoff}{numeric between 0 and 1. Variables with correlations below
this cutoff in absolute value are not plotted (see Details).}

\item{rad.in}{numeric between 0 and 1, the radius of the inner circle.
Defaults to \code{0.5}.}

\item{title}{character indicating the title plot.}

\item{legend}{Logical when more than 3 blocks. Can be a character vector
when one or 2 blocks to customize the legend. See examples. Default is
FALSE.}

\item{legend.title}{title of the legend}

\item{style}{argument to be set to either \code{'graphics'},
\code{'lattice'}, \code{'ggplot2'} or \code{'3d'} for a style of plotting.}

\item{overlap}{Logical. Whether the variables should be plotted in one
single figure. Default is TRUE.}

\item{axes.box}{for style '3d', argument to be set to either \code{'axes'},
\code{'box'}, \code{'bbox'} or \code{'all'}, defining the shape of the box.}

\item{label.axes.box}{for style '3d', argument to be set to either
\code{'axes'}, \code{'box'}, \code{'both'}, indicating which labels to
print.}
}
\value{
A list containing the following components: \item{x}{a vector of
coordinates of the variables on the x-axis.} \item{y}{a vector of
coordinates of the variables on the y-axis.} \item{Block}{the data block
name each variable belongs to.} \item{names}{the name of each variable,
matching their coordinates values.}
}
\description{
This function provides variables representation for (regularized) CCA,
(sparse) PLS regression, PCA and (sparse) Regularized generalised CCA.
}
\details{
\code{plotVar} produce a "correlation circle", i.e. the correlations between
each variable and the selected components are plotted as scatter plot, with
concentric circles of radius one et radius given by \code{rad.in}. Each
point corresponds to a variable. For (regularized) CCA the components
correspond to the equiangular vector between \eqn{X}- and \eqn{Y}-variates.
For (sparse) PLS regression mode the components correspond to the
\eqn{X}-variates. If mode is canonical, the components for \eqn{X} and
\eqn{Y} variables correspond to the \eqn{X}- and \eqn{Y}-variates
respectively.

For \code{plsda} and \code{splsda} objects, only the \eqn{X} variables are
represented.

For \code{spls} and \code{splsda} objects, only the \eqn{X} and \eqn{Y}
variables selected on dimensions \code{comp} are represented.

The arguments \code{col}, \code{pch}, \code{cex} and \code{font} can be
either vectors of length two or a list with two vector components of length
\eqn{p} and \eqn{q} respectively, where \eqn{p} is the number of
\eqn{X}-variables and \eqn{q} is the number of \eqn{Y}-variables. In the
first case, the first and second component of the vector determine the
graphics attributes for the \eqn{X}- and \eqn{Y}-variables respectively.
Otherwise, multiple arguments values can be specified so that each point
(variable) can be given its own graphic attributes. In this case, the first
component of the list correspond to the \eqn{X} attributs and the second
component correspond to the \eqn{Y} attributs. Default values exist for this
arguments.
}
\examples{
## variable representation for objects of class 'rcc'
# ----------------------------------------------------
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene
nutri.res <- rcc(X, Y, ncomp = 3, lambda1 = 0.064, lambda2 = 0.008)

plotVar(nutri.res) #(default)


plotVar(nutri.res, comp = c(1,3), cutoff = 0.5)

\dontrun{
## variable representation for objects of class 'pls' or 'spls'
# ----------------------------------------------------
data(liver.toxicity)
X <- liver.toxicity$gene
Y <- liver.toxicity$clinic
toxicity.spls <- spls(X, Y, ncomp = 3, keepX = c(50, 50, 50),
keepY = c(10, 10, 10))

plotVar(toxicity.spls, cex = c(1,0.8))

# with a customized legend
plotVar(toxicity.spls, legend = c("block 1", "my block 2"),
legend.title="my legend")

## variable representation for objects of class 'splsda'
# ----------------------------------------------------

data(liver.toxicity)
X <- liver.toxicity$gene
Y <- as.factor(liver.toxicity$treatment[, 4])

ncomp <- 2
keepX <- rep(20, ncomp)

splsda.liver <- splsda(X, Y, ncomp = ncomp, keepX = keepX)
plotVar(splsda.liver)

## variable representation for objects of class 'sgcca' (or 'rgcca')
# ----------------------------------------------------
## see example in ??wrapper.sgcca
data(nutrimouse)
# need to unmap the Y factor diet
Y = unmap(nutrimouse$diet)
# set up the data as list
data = list(gene = nutrimouse$gene, lipid = nutrimouse$lipid, Y = Y)

# set up the design matrix:
# with this design, gene expression and lipids are connected to the diet factor
# design = matrix(c(0,0,1,
#                   0,0,1,
#                   1,1,0), ncol = 3, nrow = 3, byrow = TRUE)

# with this design, gene expression and lipids are connected to the diet factor
# and gene expression and lipids are also connected
design = matrix(c(0,1,1,
1,0,1,
1,1,0), ncol = 3, nrow = 3, byrow = TRUE)


#note: the penalty parameters will need to be tuned
wrap.result.sgcca = wrapper.sgcca(X = data, design = design, penalty = c(.3,.3, 1),
ncomp = 2,
scheme = "centroid")
wrap.result.sgcca

#variables selected on component 1 for each block
selectVar(wrap.result.sgcca, comp = 1, block = c(1,2))$'gene'$name
selectVar(wrap.result.sgcca, comp = 1, block = c(1,2))$'lipid'$name

#variables selected on component 2 for each block
selectVar(wrap.result.sgcca, comp = 2, block = c(1,2))$'gene'$name
selectVar(wrap.result.sgcca, comp = 2, block = c(1,2))$'lipid'$name

plotVar(wrap.result.sgcca, comp = c(1,2), block = c(1,2), comp.select = c(1,1),
title = c('Variables selected on component 1 only'))


plotVar(wrap.result.sgcca, comp = c(1,2), block = c(1,2), comp.select = c(2,2),
title = c('Variables selected on component 2 only'))

# -> this one shows the variables selected on both components
plotVar(wrap.result.sgcca, comp = c(1,2), block = c(1,2),
title = c('Variables selected on components 1 and 2'))

## variable representation for objects of class 'rgcca'
# ----------------------------------------------------

data(nutrimouse)
# need to unmap Y for an unsupervised analysis, where Y is included as a data block in data
Y = unmap(nutrimouse$diet)

data = list(gene = nutrimouse$gene, lipid = nutrimouse$lipid, Y = Y)
# with this design, all blocks are connected
design = matrix(c(0,1,1,1,0,1,1,1,0), ncol = 3, nrow = 3,
byrow = TRUE, dimnames = list(names(data), names(data)))

nutrimouse.rgcca <- wrapper.rgcca(X = data,
design = design,
tau = "optimal",
ncomp = 2,
scheme = "centroid")

plotVar(nutrimouse.rgcca, comp = c(1,2), block = c(1,2), cex = c(1.5, 1.5))


plotVar(nutrimouse.rgcca, comp = c(1,2), block = c(1,2))


# set up the data as list
data = list(gene = nutrimouse$gene, lipid = nutrimouse$lipid, Y =Y)
# with this design, gene expression and lipids are connected to the diet factor
# design = matrix(c(0,0,1,
#                   0,0,1,
#                   1,1,0), ncol = 3, nrow = 3, byrow = TRUE)

# with this design, gene expression and lipids are connected to the diet factor
# and gene expression and lipids are also connected
design = matrix(c(0,1,1,
1,0,1,
1,1,0), ncol = 3, nrow = 3, byrow = TRUE)
#note: the tau parameter is the regularization parameter
wrap.result.rgcca = wrapper.rgcca(X = data, design = design, tau = c(1, 1, 0),
ncomp = 2,
scheme = "centroid")
#wrap.result.rgcca
plotVar(wrap.result.rgcca, comp = c(1,2), block = c(1,2))

}
}
\references{
González I., Lê Cao K-A., Davis, M.J. and Déjean, S. (2012).
Visualising associations between paired 'omics data sets. J. Data Mining
5:19. \url{http://www.biodatamining.org/content/5/1/19/abstract}
}
\seealso{
\code{\link{cim}}, \code{\link{network}}, \code{\link{par}} and
http://www.mixOmics.org for more details.
}
\author{
Ignacio González, Benoit Gautier, Francois Bartolo, Florian Rohart,
Kim-Anh Lê Cao, Al J Abadi
}
\keyword{dplot}
\keyword{hplot}
\keyword{multivariate}
