% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.dta.R
\name{read.dta}
\alias{read.dta}
\title{Read Stata DTA File}
\usage{
read.dta(file, use.value.labels = FALSE, formats = FALSE, label = FALSE, labels = FALSE,
         missing = FALSE,   widths = FALSE, as.data.frame = TRUE, check = TRUE)
}
\arguments{
\item{file}{a character string indicating the name of the Stata
data file with or without file extension '.dta', e.g.,
\code{"Stata_Data.dta"} or \code{"Stata_Data"}.}

\item{use.value.labels}{logical: if \code{TRUE}, variables with value labels
are converted into factors.}

\item{formats}{logical: if \code{TRUE} (default), variable formats are
shown in an attribute for all variables.}

\item{label}{logical: if \code{TRUE}, variable labels are
shown in an attribute for all variables.}

\item{labels}{logical: if \code{TRUE}, value labels are
shown in an attribute for all variables.}

\item{missing}{logical: if \code{TRUE}, convert tagged missing values
to regular R \code{NA}.}

\item{widths}{logical: if \code{TRUE}, widths are shown in an attribute
for all variables.}

\item{as.data.frame}{logical: if \code{TRUE} (default), function returns a
regular data frame;
if \code{FALSE} function returns a tibble.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}
}
\value{
Returns a data frame or tibble.
}
\description{
This function calls the \code{read_dta} function in the \pkg{haven} package
by Hadley Wickham, Evan Miller and Danny Smith (2023) to read a Stata DTA file.
}
\note{
This function is a modified copy of the \code{read_dta()} function in the
\pkg{haven} package by Hadley Wickham, Evan Miller and Danny Smith (2023).
}
\examples{
\dontrun{

read.dta("Stata_Data.dta")
read.dta("Stata_Data")

# Example 2: Read Stata data, convert variables with value labels into factors
read.dta("Stata_Data.dta", use.value.labels = TRUE)

# Example 3: Read Stata data as tibble
read.dta("Stata_Data.dta", as.data.frame = FALSE)
}
}
\references{
Wickham H, Miller E, Smith D (2023). \emph{haven: Import and Export 'SPSS',
'Stata' and 'SAS' Files}. R package version 2.5.3.
\url{https://CRAN.R-project.org/package=haven}
}
\seealso{
\code{\link{read.sav}}, \code{\link{write.sav}}, \code{\link{read.xlsx}},
 \code{\link{write.xlsx}}, \code{\link{read.mplus}}, \code{\link{write.mplus}}
}
\author{
Hadley Wickham and Evan Miller
}
