% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagged.R
\name{lagged}
\alias{lagged}
\title{Create Lagged Variables}
\usage{
lagged(..., data = NULL, id = NULL, obs = NULL, day = NULL, lag = 1, time = NULL,
       units = c("secs", "mins", "hours", "days", "weeks"), append = TRUE,
       name = ".lag", name.td = ".td", as.na = NULL, check = TRUE)
}
\arguments{
\item{...}{a vector for computing a lagged values for a variable, matrix
or data frame for computing lagged values for more than one
variable. Note that the subject ID variable (\code{id}),
observation number variable (\code{obs}), day number variable
(\code{day}), and the date and time variable (\code{time}) are
excluded from \code{...} when specifying the argument the
using the names of the variables. Alternatively, an expression
indicating the variable names in \code{data}. Note that the
operators \code{.}, \code{+}, \code{-}, \code{~}, \code{:},
\code{::}, and \code{!} can also be used to select variables,
see 'Details' in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a vector, matrix, or data frame for the argument
\code{...}.}

\item{id}{either a character string indicating the variable name of the
subject ID variable in '...' or a vector representing the
subject IDs, see 'Details'.}

\item{obs}{either a character string indicating the variable name of the
observation number variable in '...' or a vector representing
the observations. Note that duplicated values within the same
subject ID are not allowed, see 'Details'.}

\item{day}{either a character string indicating the variable name of the
day number variable in '...' or a vector representing the days,
see 'Details'.}

\item{lag}{a numeric value specifying the lag, e.g. \code{lag = 1} (default)
returns lag-1 values.}

\item{time}{a variable of class \code{POSIXct} or \code{POSIXlt} representing
the date and time of the observation used to compute time
differences between observations.}

\item{units}{a character string indicating the units in which the time
difference is represented, i.e., \code{"secs"} for seconds,
\code{"mins"} (default) for minutes, \code{"hours"} for hours,
\code{"days"} for days, and \code{"weeks"} for weeks.}

\item{append}{logical: if \code{TRUE} (default), lagged variable(s) are
appended to the data frame specified in the argument \code{data}.}

\item{name}{a character string or character vector indicating the names of
the lagged variables. By default, lagged variables are named
with the ending \code{".lag"} resulting in e.g. \code{"x1.lag"}
and \code{"x2.lag"} when specifying two variables. Variable
names can also be specified using a character vector matching
the number of variables specified in \code{...}, e.g.
\code{name = c("lag.x1", "lag.x2")}).}

\item{name.td}{a character string or character vector indicating the names of
the time difference variables when specifying a date and time
variables for the argument \code{time}. By default, time
difference variables are named with the ending \code{".td"}
resulting in e.g. \code{"x1.td"} and \code{"x2.td"} when
specifying two variables. Variable names can also be specified
using a character vector matching the number of variables
specified in \code{...}, e.g. \code{name = c("td.x1", "td.x2")}).}

\item{as.na}{a numeric vector indicating user-defined missing values, i.e.
these values are converted to \code{NA} before conducting the
analysis. Note that \code{as.na()} function is only applied to
the argument \code{x}, but not to \code{cluster}.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}
}
\value{
Returns a numeric vector or data frame with the same length or same number of
rows as \code{...} containing the lagged variable(s).
}
\description{
This function computes lagged values of variables by a specified number of
observations. By default, the function returns lag-1 values of the vector,
matrix, or data frame specified in the first argument.
}
\details{
\describe{
The function is used to create lagged version of the variable(s) specified via
the \code{...} argument:
\item{\strong{Optional argument \code{id}}}{If the \code{id} argument is not specified
\code{i.e., id = NULL}, all observations are assumed to come from the same
subject.  If the dataset includes multiple subjects, then this variable needs
to be specified so that observations are not lagged across subjects}
\item{\strong{Optional argument \code{day}}}{If the \code{day} argument is not specified
\code{i.e., day = NULL}, values of the variable to be lagged are allowed to be
lagged across days in case there are multiple observation days.}
\item{\strong{Optional argument \code{obs}}}{If the \code{obs} argument is not specified
\code{i.e., obs = NULL}, consecutive observations from the same subjects are
assumed to be one lag apart.}

}
}
\note{
This function is a based on the \code{lagvar()} function in the \pkg{esmpack}
package by Wolfgang Viechtbauer and Mihail Constantin (2023).
}
\examples{
dat <- data.frame(subject = rep(1:2, each = 6),
                   day = rep(1:2, each = 3),
                   obs = rep(1:6, times = 2),
                   time = as.POSIXct(c("2024-01-01 09:01:00", "2024-01-01 12:05:00",
                                       "2024-01-01 15:14:00", "2024-01-02 09:03:00",
                                       "2024-01-02 12:21:00", "2024-01-02 15:03:00",
                                       "2024-01-01 09:02:00", "2024-01-01 12:09:00",
                                       "2024-01-01 15:06:00", "2024-01-02 09:02:00",
                                       "2024-01-02 12:15:00", "2024-01-02 15:06:00")),
                    pos = c(6, 7, 5, 8, NA, 7, 4, NA, 5, 4, 5, 3),
                    neg = c(2, 3, 2, 5, 3, 4, 6, 4, 6, 4, NA, 8))

# Example 1a: Lagged variable for 'pos'
lagged(dat$pos, id = dat$subject, day = dat$day)

# Example 1b: Alternative specification
lagged(dat[, c("pos", "subject", "day")], id = "subject", day = "day")

# Example 1c: Alternative specification using the 'data' argument
lagged(pos, data = dat, id = "subject", day = "day")

# Example 2a: Lagged variable for 'pos' and 'neg'
lagged(dat[, c("pos", "neg")], id = dat$subject, day = dat$day)

# Example 2b: Alternative specification using the 'data' argument
lagged(pos, neg, data = dat, id = "subject", day = "day")

# Example 3: Lag-2 variables for 'pos' and 'neg'
lagged(pos, neg, data = dat, id = "subject", day = "day", lag = 2)

# Example 4: Lagged variable and time difference variable
lagged(pos, neg, data = dat, id = "subject", day = "day", time = "time")

# Example 5: Lagged variables and time difference variables,
# name variables
lagged(pos, neg, data = dat, id = "subject", day = "day", time = "time",
       name = c("p.lag1", "n.lag1"), name.td = c("p.diff", "n.diff"))

# Example 6: NA observations excluded from the data frame
dat.excl <- dat[!is.na(dat$pos), ]

# Number of observation not taken into account, i.e.,
# - observation 4 used as lagged value for observation 6 for subject 1
# - observation 1 used as lagged value for observation 3 for subject 2
lagged(pos, data = dat.excl, id = "subject", day = "day")

# Number of observation taken into account by specifying the 'ob' argument
lagged(pos, data = dat.excl, id = "subject", day = "day", obs = "obs")
}
\references{
Viechtbauer W, Constantin M (2023). \emph{esmpack: Functions that facilitate
preparation and management of ESM/EMA data}. R package version 0.1-20.
}
\seealso{
\code{\link{center}}, \code{\link{rec}}, \code{\link{coding}}, \code{\link{item.reverse}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
