% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blimp.update.R
\name{blimp.update}
\alias{blimp.update}
\title{Blimp Input Updating}
\usage{
blimp.update(x, update, file = "Blimp_Input_Update.imp", comment = FALSE,
             replace.inp = TRUE, blimp.run = TRUE, posterior = FALSE,
             folder = "Posterior_",
             format = c("csv", "csv2", "xlsx", "rds", "RData"),
             clear = TRUE, replace.out = c("always", "never", "modified"),
             Blimp = detect.blimp(),
             result = c("all", "default", "algo.options",  "data.info",
                        "model.info", "warn.mess", "out.model", "gen.param"),
             exclude = NULL, color = c("none", "blue", "violet"),
             style = c("bold", "regular"), not.result = TRUE,
             write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{\code{misty.object} object of type \code{blimp}.}

\item{update}{a character vector containing the updated input command
sections.}

\item{file}{a character string indicating the name of the updated Blimp
input file with or without the file extension \code{.imp},
e.g., \code{"Blimp_Input_Update.imp"} or
\code{"Blimp_Input_Update.imp"}.}

\item{comment}{logical: if \code{FALSE} (default), comments (i.e., text
after the \code{#} symbol) are removed from the input text
specified in the argument \code{x}.}

\item{replace.inp}{logical: if \code{TRUE} (default), an existing input
file will be replaced.}

\item{blimp.run}{logical: if \code{TRUE}, the input file specified in the
argument \code{file} containing the input text specified
in the argument \code{x} is run using the \code{blimp.run()}
function.}

\item{posterior}{logical: if \code{TRUE}, the posterior distribution including
burn-in and post-burn-in phase for all parameters are saved
in long format in a file called \code{posterior.*} in the
folder specified in the argument \code{folder} and \code{.imp}
file name in the format specified in the argument \code{format}.}

\item{folder}{a character string indicating the prefix of the folder for
saving the posterior distributions. The default setting is
\code{folder = "Posterior_"}.}

\item{format}{a character vector indicating the file format(s) for saving the
posterior distributions, i.e., \code{"csv"} (default) for
\code{write.csv()}, \code{"csv2"} for \code{write.csv2()},
\code{"xlsx"} for \code{write.xlsx()}, \code{"rds"} for
\code{saveRDS()}, and \code{"RData"} for \code{write()}.}

\item{clear}{logical: if \code{TRUE} (default), the console is cleared
after estimating each model.}

\item{replace.out}{a character string for specifying three settings:
\code{"always"} (default), which runs all models, regardless
of whether an output file for the model exists, \code{"never"},
which does not run any model that has an existing output file,
and \code{"modified"}, which only runs a model if the
modified date for the input file is more recent than the
output file modified date.}

\item{Blimp}{a character string for specifying the name or path of the
Blimp executable to be used for running models. This covers
situations where Blimp is not in the system's path, or where
one wants to test different versions of the Blimp program.
Note that there is no need to specify this argument for most
users since it has intelligent defaults.}

\item{result}{a character vector specifying Blimp result sections included
in the output (see 'Details' in the \code{\link{blimp.print}}
function).}

\item{exclude}{a character vector specifying Blimp input command or result
sections excluded from the output (see 'Details' in the
\code{\link{blimp.print}} function).}

\item{color}{a character vector with two elements indicating the colors
used for headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the header \code{Outcome Variable:} and
\code{Missing predictor:} including variables names.}

\item{style}{a character vector with two elements indicating the style
used for headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the header \code{Outcome Variable:} and
\code{Missing predictor:} including variables names, i.e.,
\code{regular}, for regular text, \code{bold} for bold text,
\code{italic}, for italic text, and \code{underline} for
underline text.}

\item{not.result}{logical: if \code{TRUE} (default), character vector indicating
the result sections not requested are shown on the console.}

\item{write}{a character string naming a file for writing the output into
a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}).}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console by using the function \code{blimp.print()}.}

\item{data}{a matrix or data frame from which the variables names for
the section \code{VARIABLES} are extracted when using the
\code{...} specification in the \code{VARIABLES} section.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{\code{misty.object} object of type \code{blimp}}
\item{\code{update}}{a character vector containing the updated Blimp input command
                     sections}
\item{\code{args}}{specification of function arguments}
\item{\code{write}}{updated write command sections}
\item{\code{result}}{list with result sections (\code{result})}
}
\description{
This function updates specific input command sections of a \code{misty.object}
of type \code{blimp} to create an updated Blimp input file, run the updated
input file by using the \code{blimp.run()} function, and print the updated
Blimp output file by using the \code{blimp.print()} function.
}
\details{
\describe{
  \item{\strong{Bimp Input Sections}}{The function is used to update
  following Blimp input sections:
    \itemize{
     \item{\code{DATA}}
     \item{\code{VARIABLES}}
     \item{\code{CLUSTERID}}
     \item{\code{ORDINAL}}
     \item{\code{NOMINAL}}
     \item{\code{COUNT}}
     \item{\code{WEIGHT}}
     \item{\code{MISSING}}
     \item{\code{LATENT}}
     \item{\code{RANDOMEFFECT}}
     \item{\code{TRANSFORM}}
     \item{\code{BYGROUP}}
     \item{\code{FIXED}}
     \item{\code{CENTER}}
     \item{\code{MODEL}}
     \item{\code{SIMPLE}}
     \item{\code{PARAMETERS}}
     \item{\code{TEST}}
     \item{\code{FCS}}
     \item{\code{SIMUALTE}}
     \item{\code{SEED}}
     \item{\code{BURN}}
     \item{\code{ITERATIONS}}
     \item{\code{CHAINS}}
     \item{\code{NIMPS}}
     \item{\code{THIN}}
     \item{\code{OPTIONS}}
     \item{\code{OUTPUT}}
     \item{\code{SAVE}}
    }
  }
  \item{\strong{The \code{---;} Specification}}{The \code{---;} specification
  is used to remove entire sections (e.g., \code{CENTER: ---;}) from the Blimp
  input. Note that \code{---;} including the semicolon \code{;} needs to be
  specified, i.e., \code{---} without the semicolon \code{;} will result in an
  error message.}
}
}
\examples{
\dontrun{

#----------------------------------------------------------------------------
# Example 1a: Update BURN and ITERATIONS section

# Specify Blimp input
input <- '
DATA: data1.csv;
ORDINAL: d;
MISSING: 999;
FIXED: d;
CENTER: x1 x2;
MODEL: y ~ x1 x2 d;
SEED: 90291;
BURN: 1000;
ITERATIONS: 10000;
'

# Run Blimp input
mod0 <- blimp(input, file = "Ex4.3.imp", clear = FALSE)

# Update sections
update1 <- '
BURN: 5000;
ITERATIONS: 20000;
'

# Run updated Blimp input
mod1 <- blimp.update(mod0, update1, file = "Ex4.3_update1.imp")

#----------------------------------------------------------------------------
# Example 1b: Remove CENTER section

# Remove section
update2 <- '
CENTER: ---;
'

# Run updated Blimp input
mod3 <- blimp.update(mod1, update2, file = "Ex4.3_update2.imp")
}
}
\references{
Keller, B. T., & Enders, C. K. (2023). \emph{Blimp user’s guide} (Version 3).
Retrieved from www.appliedmissingdata.com/blimp
}
\seealso{
\code{\link{blimp.run}}, \code{\link{blimp.print}}, \code{\link{blimp.plot}}, \code{\link{blimp.bayes}}
}
\author{
Takuya Yanagida
}
