% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.lpa.R
\name{result.lpa}
\alias{result.lpa}
\title{Result Table for Latent Profile Analysis Estimated in Mplus}
\usage{
result.lpa(folder = getwd(), sort.n = TRUE, sort.p = TRUE,
           digits = 1, p.digits = 3, write = NULL, check = TRUE,
           output = TRUE)
}
\arguments{
\item{folder}{a character string indicating the path of the folder
containing subfolders with the Mplus output files. By
default Mplus outputs in the subfolders of the current
working directory are read.}

\item{sort.n}{logical: if \code{TRUE} (default), result table is sorted
according to the number of profiles within each folder.}

\item{sort.p}{logical: if \code{TRUE} (default), class proportions are
sorted decreasing.}

\item{digits}{an integer value indicating the number of decimal places
to be used for displaying results. Note that the scaling
correction factor is displayed  with \code{digits} plus 1
decimal places.}

\item{p.digits}{an integer value indicating the number of decimal places
to be used for displaying \emph{p}-values, entropy value,
and class proportions.}

\item{write}{a character string for writing the results into a Excel
file naming a file with or without file extension '.xlsx',
e.g., \code{"Results.xlsx"} or \code{"Results"}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object, which is a list with following entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{output}}{list with all Mplus outputs}
\item{\code{args}}{specification of function arguments}
\item{\code{result}}{table with results of all Mplus outputs}
}
\description{
This function reads all Mplus output files from latent profile analysis in the
subfolders to create a summary result table. By default, the function reads
output files in all subfolders of the current working directory. Note that all
output files need to be based on \code{ANALYSIS: TYPE IS MIXTURE} and each
subfolder needs to contain more than one \code{TYPE IS MIXTURE} output file.
}
\details{
The result summary table comprises following entries:
\itemize{
   \item{\code{"Folder"}}: Subfolder from which the group of Mplus outputs files
                           were summarized.
   \item{\code{"#Prof"}}: Number of profiles (i.e., \code{CLASSES ARE c(#Prof)}).
   \item{\code{"Conv"}}: Model converged, \code{TRUE} or \code{FALSE} (i.e.,
                         \code{THE MODEL ESTIMATION TERMINATED NORMALLY}.
   \item{\code{"#Param"}}: Number of estimated parameters (i.e.,
                           \code{Number of Free Parameters}).
   \item{\code{"logLik"}}: Log-likelihood of the estimated model (i.e., \code{H0 Value}).
   \item{\code{"Scale"}}: Scaling correction factor (i.e.,
                          \code{H0 Scaling Correction Factor for}). Provided
                          only when \code{ESTIMATOR IS MLR}.
   \item{\code{"LL Rep"}}: Best log-likelihood replicated, \code{TRUE} or \code{FALSE} (i.e.,
                           \code{THE BEST LOGLIKELIHOOD VALUE HAS BEEN REPLICATED}).
   \item{\code{"AIC"}}: Akaike information criterion (i.e., \code{Akaike (AIC)}).
   \item{\code{"CAIC"}}: Consistent AIC, not reported in the Mplut output, but
                         simply \code{BIC + #Param}.
   \item{\code{"BIC"}}: Bayesian information criterion (i.e., \code{Bayesian (BIC)}).
   \item{\code{"SABIC"}}: Sample-size adjusted BIC (i.e., \code{Sample-Size Adjusted BIC}).
   \item{\code{"LMR-LRT"}}: Significance value (\emph{p}-value) of the Vuong-Lo-Mendell-Rubin test
                            (i.e., \code{VUONG-LO-MENDELL-RUBIN LIKELIHOOD RATIO TEST}).
                            Provided only when \code{OUTPUT: TECH11}.
   \item{\code{"A-LRT"}}: Significance value (\emph{p}-value) of the Adjusted Lo-Mendell-Rubin Test
                          (i.e., \code{LO-MENDELL-RUBIN ADJUSTED LRT TEST}).
                          Provided only when \code{OUTPUT: TECH11}.
   \item{\code{"BLRT"}}: Significance value (\emph{p}-value) of the bootstrapped
                         likelihood ratio test. Provided only when \code{OUTPUT: TECH14}.
   \item{\code{"Entropy"}}: Sample-size adjusted BIC (i.e., \code{Entropy}).
   \item{\code{"p1"}}: Class proportion of the first profile based on the estimated
                       posterior probabilities (i.e., \code{FINAL CLASS COUNTS AND PROPORTIONS}).
   \item{\code{"p2"}}: Class proportion of the second profile based on the estimated
                       posterior probabilities (i.e., \code{FINAL CLASS COUNTS AND PROPORTIONS}).
 }
}
\examples{
\dontrun{
# Load data set "HolzingerSwineford1939" in the lavaan package
data("HolzingerSwineford1939", package = "lavaan")

# Run LPA with k = 1 to k = 6 profiles
mplus.lpa(HolzingerSwineford1939, ind = c("x1", "x2", "x3", "x4"),
          run.mplus = TRUE)

# Read Mplus output files, create result table, and write table
result.lpa(write = "LPA.xlsx")
}
}
\references{
Masyn, K. E. (2013). Latent class analysis and finite mixture modeling. In T. D.
Little (Ed.), \emph{The Oxford handbook of quantitative methods: Statistical analysis}
(pp. 551–611). Oxford University Press.

Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.).
Muthen & Muthen.
}
\seealso{
\code{\link{mplus.lpa}}, \code{\link{run.mplus}}, \code{\link{read.mplus}},
\code{\link{write.mplus}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
