% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.new.R
\name{script.new}
\alias{script.new}
\title{Open new R Script, R Markdown script, or SQL Script in RStudio}
\usage{
script.new(text = "", type = c("r", "rmarkdown", "sql"),
           position = rstudioapi::document_position(0, 0),
           run = FALSE, check = TRUE)
}
\arguments{
\item{text}{a character vector indicating what text should be inserted in
the new R script. By default, an empty script is opened.}

\item{type}{a character string indicating the type of document to be
created, i.e., \code{r} (default) for an R script, \code{rmakrdown}
for an R Markdown file, or \code{sql} for an SQL script.}

\item{position}{\code{document_position()} function in the \pkg{rstudioapi}
package indicating the cursor position.}

\item{run}{logical: if \code{TRUE}, the code is executed after the document
is created.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\description{
This function is used to open a new R script, R markdown script, or SQL script
in RStudio.
}
\details{
The function \code{documentNew()} in the package \pkg{rstudioapi} is used to
open an R script.
}
\examples{
\dontrun{

# Open new R script file
script.new()

# Open new R script file and run some code
script.new("#----------------------------
# Example

# Generate 100 random numbers
rnorm(100)")
}
}
\references{
Ushey, K., Allaire, J., Wickham, H., & Ritchie, G. (2022). rstudioapi: Safely
access the RStudio API. R package version 0.14.
https://CRAN.R-project.org/package=rstudioapi
}
\seealso{
\code{\link{script.close}}, \code{\link{script.open}},
\code{\link{script.save}}, \code{\link{setsource}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
