% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_r.R
\name{r}
\alias{r}
\title{Sample Correlation Coefficient (r)}
\usage{
r(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Pearson's coefficient of correlation (r) for a continuous predicted-observed dataset.
}
\details{
The r coefficient measures the strength of linear relationship between two variables.
It only accounts for precision, but it is not sensitive to lack of prediction accuracy.
It is a normalized, dimensionless coefficient, that ranges between -1 to 1. It is expected that
predicted and observed values will show 0 < r < 1.
It is also known as the Pearson Product Moment Correlation, among other names.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
r(obs = X, pred = Y)
}
}
\references{
Kirch (2008)
Pearson’s Correlation Coefficient.
\emph{In: Kirch W. (eds) Encyclopedia of Public Health. Springer, Dordrecht.}
\doi{https://doi.org/10.1007/978-1-4020-5614-7_2569}
}
