% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prior.R
\name{plot.prior}
\alias{plot.prior}
\title{Plot Prior Distribution}
\usage{
\method{plot}{prior}(x, from, to, ...)
}
\arguments{
\item{x}{prior probability density function defined via \code{\link{prior}}.}

\item{from}{lower boundary}

\item{to}{upper boundary}

\item{...}{further arguments passed to \code{\link[graphics]{plot}}}
}
\description{
Plot the probability density function of a prior distribution.
}
\examples{
p1 <- prior("t", c(location = 0, scale = 0.707, nu = 1), 0, 3)
plot(p1, 0, 2)

# define custom prior pdf up to a constant:
p2 <- prior("custom", function(x) x^.5, 0, .5)
plot(p2)
}
