% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MR_test.R
\name{MR_test}
\alias{MR_test}
\title{LM test against a change in persistence}
\usage{
MR_test(x, trend = c("none", "linear"), tau = 0.2,
  statistic = c("squared", "standard"), simu = 0, M = 10000,
  serial = c(FALSE, TRUE))
}
\arguments{
\item{x}{the univariate numeric vector to be investigated. Missing values are not allowed.}

\item{trend}{whether the time series exhibits a trend, \code{"none"} implies no trend and \code{"linear"} implies a linear trend.}

\item{tau}{the function tests in the interval \code{[T*tau,T*(1-tau)]} for a break in persistence with T being the length of the time series. It must hold that \code{0<tau<0.5}, default is \code{tau=0.2} as commonly used in the literature. Note that if \code{T*tau<=2} the test statistic cannot be calculated.}

\item{statistic}{which type of test statistic should be used, \code{"squared"} for the squared t-statistic and \code{"standard"} for the standard t-test. Default is \code{statistic="squared"}.}

\item{simu}{whether critical values should be simulated or interpolated, \code{simu=1} means simulation, \code{simu=0} means interpolation. See details. Default is \code{simu=0}.}

\item{M}{number of replications in case critical values should be simulated. Default is \code{M=10000}.}

\item{serial}{boolean, indicating whether to account for serial correlation of the errors. Default is \code{serial=FALSE} implying no correction for serial correlation.}
}
\value{
Returns a matrix that consists of test statistic and critical values (corresponding to \code{alpha=0.1,0.05,0.01}) for testing against an increase in memory, against a decrease in memory, and against a change in an unknown direction.
}
\description{
This function performs a LM-type test for a change in persistence as suggested by Martins and Rodrigues (2014).
Under the null hypothesis the memory parameter d is constant over the sample. Under the alternative
an increase or a decrease of the memory parameter has occured over time.
}
\details{
The critical values of the tests vary with sample size and memory parameter d. If \code{simu=0}, the critical values provided
are based on linear interpolation of the critical values simulated by Martins and Rodrigues (2014). These are, however, only valid for \code{tau=0.2} and \code{serial=FALSE}. 
In case that non-default values are chosen for \code{tau} or \code{serial}, it is recommended to set \code{simu=1} which means that critical values are simulated based on the given data using M replications. 
Caution, for a time series of length \code{T=750} and \code{M=10,000} replications this takes approximately twelve hours with increasing duration for higher T or M.  
It should be noted, however, that M smaller than 10,000 make the results unreliable.
}
\examples{
set.seed(410)

# generate dummy-data
series <- c(rnorm(200), cumsum(rnorm(200)))

# test for a break in persistence
MR_test(series, trend="none", statistic="squared")
}
\references{
Martins, L.. and Rodrigues, P. (2014): Testing for persistence change in fractionally integrated models: An application to world inflation rates. Computational Statistics and Data Analysis, 76, pp. 502-522.
}
\seealso{
\code{\link{cusum_test}}, \code{\link{LBI_test}}, \code{\link{LKSN_test}}, \code{\link{ratio_test}}.
}
\author{
Janis Becker
}
