% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{AUC}
\alias{AUC}
\title{Area under the curve}
\usage{
AUC(probabilities, truth, negative, positive)
}
\arguments{
\item{probabilities}{[numeric] vector of predicted probabilities}

\item{truth}{vector of true values}

\item{negative}{negative class}

\item{positive}{positive class}
}
\description{
Integral over the graph that results from computing fpr and tpr for many different thresholds.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
negative = 0
AUC(probabilities, truth, negative, positive)
}
